package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.ComboboxVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity.KhxmVO;

import java.util.List;

/**
 * <p>
 * 考核项目 服务类
 * </p>
 *
 * @author ln
 * @since 2020-03-18
 */
public interface KhxmService {

    /**
     * 新增考核项目信息
     *
     * @param khxmVO
     * @return
     */
    int insertKhxmInfo(KhxmVO khxmVO);

    /**
     * 修改考核项目信息
     *
     * @param khxmVO
     * @return
     */
    int updateById(KhxmVO khxmVO);

    /**
     * 根据ID删除考核项目信息
     *
     * @param id 　考核项目ID
     * @return
     */
    int deleteInfoById(String id);

    /**
     * 根据ID获取考核项目信息
     *
     * @param id
     * @return
     */
    KhxmVO getById(String id);

    /**
     * @param current  当前页
     * @param size     每页大小
     * @param khnr     考核内容
     * @param khxmzldm 考核项目种类代码
     * @param cj       层次
     * @param sfqy     是否启用
     * @return
     */
    Page<KhxmVO> page(long current, long size, String khnr, String khxmzldm, String cj, String sfqy);
    /**
     * 查询上级考核项目ID
     * @param khxmVO
     * @return
     */
    String findSjkhxmId(KhxmVO khxmVO);
    /**
     * 通过id查询考核项目信息
     *
     * @param khxmVO 考核项目
     * @return
     */
    KhxmVO findkhxmInfoById(KhxmVO khxmVO);
    /**
     * 查询子层的考核项目信息
     *
     * @param current
     * @param size
     * @param khxmVO  考核项目
     * @return
     */
    Page<KhxmVO> findKhxmList(long current, long size, KhxmVO khxmVO);
    /**
     * 上级考核项目下拉列表
     *
     * @param khxmzldm 考核项目种类
     * @return
     */
    List<ComboboxVo> findSjkhxmByzl(String khxmzldm);
    /**
     * 查找上级考核项目
     *
     * @param sjkhxmId 上级考核项目id
     * @return
     */
    String findSjkhnrById(String sjkhxmId);
    /**
     * 修改是否启用状态
     *
     * @param khxmVO 考核项目
     * @return
     */
    boolean updateSfqyById(KhxmVO khxmVO);

    /**
     * 考核项目是否存在
     * @param khxmVO
     * @return
     */
    String isExists(KhxmVO khxmVO);

    /**
     * 查询-项目标准配置使用
     *
     * @param khxmVO
     * @return
     */
    List<KhxmVO> allList(KhxmVO khxmVO);

    /**
     * 查询考核项目信息-项目标准配置使用(查询所有下级)
     *
     * @param khxmVO
     * @return
     */
    List<KhxmVO> findKhxmInfoList(KhxmVO khxmVO);

    /**
     * 查询考核项目信息（传的是2级的项目id）
     *
     * @return
     */
    KhxmVO findKhxmDetailById(String khxmId);

    /**
     * 插入考核项目
     *
     * @param khxmVO  考核项目
     * @param curUser
     * @return
     */
    boolean insert(KhxmVO khxmVO, SysUser curUser);
}

