package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.jdpykh.entity.PykhJKpjlb;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.common.entity.AjInfoVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.common.entity.AjPcInfoVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity.KhJlBVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity.KhbzVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity.KhbzXmGlVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity.ZfRyXxVO;

import java.util.List;

/**
 * <p>
 * 考核记录表 服务类
 * </p>
 *
 * @author 黄宇
 * @since 2020-05-07
 */
public interface KhJlBService {

    /**
     * 人员考核的页面上的列表查询
     *
     * @param current
     * @param size
     * @param khJlBVO
     * @return
     */
    Page<KhJlBVO> page(long current, long size, KhJlBVO khJlBVO);

    /**
     * 人员考核的历史的列表查询
     *
     * @param current
     * @param size
     * @param khJlBVO
     * @return
     */
    Page<KhJlBVO> khlspage(long current, long size, KhJlBVO khJlBVO);

    /**
     * 考核标准列表查询
     *
     * @param current
     * @param size
     * @param khbzVO
     * @return
     */
    Page<KhbzVO> khbzpage(long current, long size, KhbzVO khbzVO);

    /**
     * 查询人员年度考核信息查询---证件年审用
     *
     * @param nd
     * @param ZfryxxId
     * @return
     */
    List<KhJlBVO> khjgByNd(String nd, String ZfryxxId);

    /**
     * 查询考核人员
     *
     * @param current
     * @param size
     * @param zfRyXxVO
     * @return
     */
    Page<ZfRyXxVO> queryKhRy(long current, long size, ZfRyXxVO zfRyXxVO);

    /**
     * 考核标准表中的数据
     *
     * @param khbzXmGlVO
     * @return
     */
    KhbzXmGlVO queryBgData(KhbzXmGlVO khbzXmGlVO);

    /**
     * 保存考核记录表数据
     *
     * @param khResultInfo
     * @return
     */
    boolean savekhResult(String khResultInfo, SysUser sysUser);

    /**
     * 查询考核信息
     *
     * @param khjlbId
     * @return
     */
    KhJlBVO viewKhInfo(String khjlbId);

    /**
     * 案件信息查询
     *
     * @param ajInfoVO
     * @param current
     * @param size
     * @return
     */
    Page<AjInfoVO> queryAjInfo(AjInfoVO ajInfoVO, long current, long size);

    /**
     * 查询处罚案件数量
     *
     * @param ajInfoVO
     * @return
     */
    AjInfoVO queryCfAjSl(AjInfoVO ajInfoVO);

    /**
     * 查询执法人员参与许可案件数
     *
     * @param ajInfoVO
     * @return
     */
    AjInfoVO queryXkAjSl(AjInfoVO ajInfoVO);

    /**
     * 查询处罚许可的案件数量
     *
     * @param ajInfoVO
     * @return
     */
    AjInfoVO queryAjSl(AjInfoVO ajInfoVO);

    /**
     * 查询案件评查记录
     *
     * @param ajPcInfoVO
     * @return
     */
    Page<AjPcInfoVO> queryAjPcInfo(long current, long size, AjPcInfoVO ajPcInfoVO);

    /**
     * 查询评查记录
     *
     * @param ajPcInfoVO
     * @return
     */
    PykhJKpjlb queryPcResult(AjPcInfoVO ajPcInfoVO);
}

