package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 责任信息
 * </p>
 *
 * @author pt
 * @since 2020-03-23
 */
@Data
@TableName("ZFRYGL_J_ZRXX")
public class ZrxxVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 责任信息的唯一标识
     */
    @TableId
    private String zrxxId;

    /**
     * 登记机构
     */
    private String zzjgid;

    /**
     * 登记单位名称
     */
    private String djdwmc;

    /**
     * 责任名称
     */
    private String zrsgmc;

    /**
     * 发生时间
     */
    private Date fssj;
    @TableField(exist = false)
    private String fssjStart;
    @TableField(exist = false)
    private String fssjStr;
    @TableField(exist = false)
    private String fssjEnd;

    /**
     * 地点
     */
    private String sgdd;

    /**
     * 责任人姓名，多个人逗号隔开
     */
    private String zrr;

    /**
     * 责任人id，多个人逗号隔开
     */
    @TableField(exist = false)
    private String zrrids;


    /**
     * 责任事故描述
     */
    private String ms;

    /**
     * 追究意见
     */
    private String zjyj;
    /**
     * 查询范围
     */
    @TableField(exist = false)
    private String cxfw;

    /**
     * 执法责任分类代码
     */
    private String zfzrfldm;
    /**
     * 批量删除的数组
     */
    @TableField(exist = false)
    private String[] deleteIdArr;

    /**
     * 附件详情
     */
    @TableField(exist = false)
    private String fjDetail;
    /**
     * 姓名
     */
    @TableField(exist = false)
    private String xm;
    /**
     * 标记  1 标是从证件查询责任信息
     */
    @TableField(exist = false)
    private String flag;
    /**
     * 存储材料路径
     */
    @TableField(exist = false)
    private List bcljArr = new ArrayList();
    /**
     * 存储材料名称
     */
    @TableField(exist = false)
    private List clmcArr = new ArrayList();
    /**
     * 存储附件id
     */
    @TableField(exist = false)
    private List fjidArr = new ArrayList();

    /**
     * 存储附件id
     */
    @TableField(exist = false)
    private List lxArr = new ArrayList();

    /**
     * 存储附件id
     */
    @TableField(exist = false)
    private List keyArr = new ArrayList();
    /**
     * 删除的附件信息
     */
    @TableField(exist = false)
    private String[] deletefj;
    /**
     * 删除的追究-人员信息
     */
    @TableField(exist = false)
    private String[] deletery;
    /**
     * 人员-追究关联信息
     */
    @TableField(exist = false)
    private String ryglzjInfo;

    @Override
    public String getId() {
        return zrxxId;
    }

    @Override
    public void setId(String id) {
        this.zrxxId = id;
    }


}
