package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@Data
@TableName("ZFRYGL_J_KHBZ")
public class ZfryglJKhbzVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 考核标准的ID，与版本号组合主键
     */
    @TableId
    private String khbzId;
    /**
     * 考核标准版本号
     */
    private String bbh;

    /**
     * 标准分类代码
     */
    private String bzfldm;
    /**
     * 标准分类
     */
    @TableField(exist = false)
    private String bzflmc;
    /**
     * 组织机构ID
     */
    private String zzjgid;

    /**
     * 考核年度
     */
    private String khnd;

    /**
     * 标准名称
     */
    private String bzmc;

    /**
     * 标准状态：0 暂存，1 待启用，2 启用，3 禁用
     */
    private String zt;

    /**
     * 启用日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date qyrq;

    /**
     * 禁用日期
     */
    private Date jyrq;
    /**
     * 复制类型
     */
    @TableField(exist = false)
    private String fztype;
    /**
     * 制定单位
     */
    @TableField(exist = false)
    private String zddw;

    @Override
    public String getId() {
        return khbzId;
    }

    @Override
    public void setId(String id) {
        this.khbzId = id;
    }
}
