package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 执法人员信息
 * </p>
 *
 * @author 黄宇
 * @since 2020-03-18
 */
@Data
@TableName("ZFRYGL_J_ZFRYXX")
public class ZfRyXxVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 执法人员基本信息的唯一标识。
     */
    @TableId
    private String zfryxxId;

    /**
     * 学历代码
     */
    private String xldm;

    /**
     * 政治面貌代码
     */
    private String zzmmdm;

    /**
     * 人员所在机构
     */
    private String zzjgid;

    /**
     * 人员职务的代码。
     */
    private String zwdm;

    /**
     * 执法人员执法门类的代码。
     */
    private String zfmldm;

    /**
     * 人员编制的代码
     */
    private String rybzdm;

    /**
     * 职务级别代码
     */
    private String zwjbdm;

    /**
     * 任职状态代码
     */
    private String rzztdm;

    /**
     * 执法人员类型的代码。
     */
    private String zfrylxdm;

    /**
     * 人员所属民族的代码。
     */
    private String mzdm;

    /**
     * 执法人员性质代码
     */
    private String zfryxzdm;

    /**
     * 人员审批状态代码
     */
    private String ryspztdm;

    /**
     * 证件状态代码
     */
    private String zjztdm;

    /**
     * 人员的性别代码。
     */
    private String xbdm;

    /**
     * 执法人员分配渠道的代码。
     */
    private String zfryfpqddm;

    /**
     * 人员的岗位代码。
     */
    private String gwdm;

    /**
     * 执法人员的姓名。
     */
    private String xm;

    /**
     * 执法人员人员的出生日期。
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date csrq;

    /**
     * 执法人员人员的身份证号码。
     */
    private String sfzjhm;

    /**
     * 执法人员的照片
     */
    private String zpdz;

    /**
     * 执法人员入党日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date rdsj;

    /**
     * 执法人员的毕业学校。
     */
    private String byxx;

    /**
     * 执法人员的毕业专业。
     */
    private String byzy;

    /**
     * 执法人员的毕业证书号。
     */
    private String byzsh;

    /**
     * 执法人员的毕业日期。
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date byrq;

    /**
     * 执法人员参加工作的起始日期。
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date cjgzsj;

    /**
     * 执法人员的通讯地址
     */
    private String txdz;

    /**
     * 执法人员通讯地址的邮政编码
     */
    private String yzbm;

    /**
     * 执法人员的联系电话。
     */
    private String lxdh;

    /**
     * 执法人员从事执法工作的起始日期。
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date cszfrq;

    /**
     * 执法人员入职日期。
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date rzsj;

    /**
     * 现有省内执法证号
     */
    private String xysnzfzh;

    /**
     * 现有部级执法证号
     */
    private String xybjzfzh;

    /**
     * 执法证号
     */
    private String zfzh;

    /**
     * 执法人员岗位培训证书编号。
     */
    private String gwpxzsbh;

    /**
     * 执法人员的执法区域。
     */
    private String zfqy;

    /**
     * 关联附件键值，逗号分隔，单项键值固定32字节
     */
    private String zlfj;

    /**
     * 备注
     */
    private String bz;
    /**
     * 是否具有法律职业资格
     */
    private String sfjyflzyzg;
    /**
     * 是否监督人员
     */
    private String sfjdry;
    /**
     * 资格证书编号
     */
    private String zgzsbh;
    /**
     * 专业分类代码
     */
    private String zyfldm;
    /**
     * 学历代码
     */
    private String xldmdl;
    /**
     * 新增的岗位等级代码
     */
    private String gwdjdmValue;
   /**
     * 是否更新
    * 0-否
    * 1-是
     */
    private String sfgx;

    /* --------------------表外字段---------------------------------*/

    /**
     * 新增的岗位等级代码
     */
    @TableField(exist = false)
    private String[] gwdjdmValueArr;
    /**
     * 执法人员年龄
     */
    @TableField(exist = false)
    private String age;
    /**
     * 查询范围
     */
    @TableField(exist = false)
    private String cxfw;

    /**
     * 组织机构
     */
    @TableField(exist = false)
    private String zzjg;

    /**
     * 当前用户
     */
    @TableField(exist = false)
    private SysUser sysUser;
    /**
     * 机构名称
     */
    @TableField(exist = false)
    private String orgName;
    /**
     * 机构id
     */
    @TableField(exist = false)
    private String orgId;
    /**
     * 出生日期
     */
    @TableField(exist = false)
    private String csrqStr;
    /**
     * 入党日期
     */
    @TableField(exist = false)
    private String rdrqStr;
    /**
     * 执法人员参加工作的起始日期。
     */
    @TableField(exist = false)
    private String cjgzrqStr;
    /**
     * 执法人员从事执法工作的起始日期。
     */
    @TableField(exist = false)
    private String cszfgzrqStr;
    /**
     * 照片附件ID
     */
    @TableField(exist = false)
    private String[] zpfjid;
    /**
     * 档案文件附件ID
     */
    @TableField(exist = false)
    private String[] dawjfjid;

    /**
     * 存储材料路径
     */
    @TableField(exist = false)
    private List bcljArr = new ArrayList();
    /**
     * 存储材料名称
     */
    @TableField(exist = false)
    private List clmcArr = new ArrayList();
    /**
     * 存储附件id
     */
    @TableField(exist = false)
    private List fjidArr = new ArrayList();
    /**
     * 存储附件类型
     */
    @TableField(exist = false)
    private List lxArr = new ArrayList();

    /**
     * 人员状态代码
     */
    @TableField(exist = false)
    private String ryztdmCode;

    /**
     * 标记 1 代表申请准入 2代表申请发证
     */
    @TableField(exist = false)
    private String flag;

    /**
     * 任职状态
     */
    @TableField(exist = false)
    private String rzztdmCode;

    /**
     * 主键ID数组
     */
    @TableField(exist = false)
    private String[] zfryxxIds;
    /**
     * 审批机关
     */
    @TableField(exist = false)
    private String spjg;
    /***
     * 调动原因
     */
    @TableField(exist = false)
    private String ddyy;

    /**
     * 照片附件
     */
    @TableField(exist = false)
    private String zpfjDetail;
    /**
     * 档案附件
     */
    @TableField(exist = false)
    private String dawjDetail;

    /**
     * 需要删除的照片附件
     */
    @TableField(exist = false)
    private String[] deletezpfj;
    /**
     * 需要删除的档案附件
     */
    @TableField(exist = false)
    private String[] deletedawj;

    /**
     * 职务代码字典值
     */
    @TableField(exist = false)
    private String zwdmCode;
    /**
     * 执法人员执法门类的代码字典值
     */
    @TableField(exist = false)
    private String zfmldmCode;
    /**
     * 证件状态代码字典值
     */
    @TableField(exist = false)
    private String zjztdmCode;
    /**
     * 人员所属民族的代码字典值
     */
    @TableField(exist = false)
    private String mzdmCode;
    /**
     * 政治面貌代码字典值
     */
    @TableField(exist = false)
    private String zzmmdmCode;
    /**
     * 学历代码字典值
     */
    @TableField(exist = false)
    private String xldmCode;
    /**
     * 执法人员分配渠道的代码字典值
     */
    @TableField(exist = false)
    private String zfryfpqddmCode;
    /**
     * 执法人员性质代码字典值
     */
    @TableField(exist = false)
    private String zfryxzdmCode;
    /**
     * 人员编制的代码字典值
     */
    @TableField(exist = false)
    private String rybzdmCode;
    /**
     * 职务级别代码字典值
     */
    @TableField(exist = false)
    private String zwjbdmCode;
    /**
     * 人员的岗位代码字典值
     */
    @TableField(exist = false)
    private String gwdmCode;
    /**
     * 申请 和审批的时候上传附件的参数
     */
    @TableField(exist = false)
    private String scfj;
    /**
     * 文件路径
     */
    @TableField(exist = false)
    private List filePath = new ArrayList();
    /**
     * 文件类型
     */
    @TableField(exist = false)
    private List fileType = new ArrayList();
    /**
     * 文件原始名称
     */
    @TableField(exist = false)
    private List oldFileName = new ArrayList();
    /**
     * 抽取数量
     */
    @TableField(exist = false)
    private String num;


    /**
     * 人员教育失败个数
     */
    @TableField(exist = false)
    private int jyFailCount;
    /**
     * 培训
     */
    @TableField(exist = false)
    private int pxFailCount;
    /**
     * 考试
     */
    @TableField(exist = false)
    private int ksFailCount;
    /*
    奖励
     */
    @TableField(exist = false)
    private int jlFailCount;
    /**
     * 惩罚
     */
    @TableField(exist = false)
    private int cfFailCount;

    /**
     * 教育总数
     */
    @TableField(exist = false)
    private int ryjyZs;

    /**
     * 培训总数
     */
    @TableField(exist = false)
    private int rypxZs;
    /**
     * 考试总数
     */
    @TableField(exist = false)
    private int ryksZs;
    /**
     * 奖励总数
     */
    @TableField(exist = false)
    private int ryjlZs;
    /**
     * 惩罚总数
     */
    @TableField(exist = false)
    private int rycfZs;
    /**
     * 成功导入的条数
     */
    @TableField(exist = false)
    private int daoRuCount;
    /**
     * 失败的总条数
     */
    @TableField(exist = false)
    private int faileCount;

    /**
     * 返回失败的身份证号
     */
    @TableField(exist = false)
    private List<String> listAllDistinct;
    /**
     * 1 为人员信息导入  2 为人员附加信息导入
     */
    @TableField(exist = false)
    private String drFlag;
    /*
        导入人员信息的总数
     */
    @TableField(exist = false)
    private int ryInfoCount;
    /**
     * excel导入的数据集合
     */
    @TableField(exist = false)
    private List<ZfRyXxVO> excelDaoRuData;
    /**
     * excel导入数据不符合要求的集合
     */
    @TableField(exist = false)
    private List<String> excelFailData;

    /**
     * excel导入数据为空提示
     */
    @TableField(exist = false)
    private String excelDataNull;

    /**
     * 教育信息导入不符合要求的数据
     */
    @TableField(exist = false)
    private List<String> failRyJyInfo;
    /**
     * 验证表格中不符合要求的身份证号码
     */
    @TableField(exist = false)
    private List<String> failSfZhM;
    /**
     * 填写错误的组织机构
     */
    @TableField(exist = false)
    private List<String> failZzJg;
    /**
     * 填写错误的职务
     */
    @TableField(exist = false)
    private List<String> failzw;
    /**
     * 身份证号码已经存在数据库
     */
    @TableField(exist = false)
    private List<String> alreadysfzjhm;

    /**
     * 联系电话已经存在数据库
     */
    @TableField(exist = false)
    private List<String> alreadyLxdh;

    /**
     * 人员基本信息的毕业日期字符串
     */
    @TableField(exist = false)
    private String byrqStrS;

    /**
     * 人员审批状态代码Text
     */
    @TableField(exist = false)
    private String ryspztdmText;

    /**
     * 人员职务的代码Text。
     */
    @TableField(exist = false)
    private String zwdmText;

    /**
     * 执法人员执法门类的代码Text。
     */
    @TableField(exist = false)
    private String zfmldmText;

    /**
     * 任职状态代码Text
     */
    @TableField(exist = false)
    private String rzztdmText;

    /**
     * 证件状态代码Text
     */
    @TableField(exist = false)
    private String zjztdmText;

    /**
     * 人员的性别代码Text。
     */
    @TableField(exist = false)
    private String xbdmText;
    /**
     * 人员的入职时间
     */
    @TableField(exist = false)
    private String rzsjStr;
    /**
     * 重复身份证号
     */
    @TableField(exist = false)
    private List<String> chongfuSfzjhm;
    /**
     * 已经存在的执法证号
     */
    @TableField(exist = false)
    private List<String> alreadyZfzh;
    /**
     * 输入不正确的姓名
     */
    @TableField(exist = false)
    private List<String> errorXmList;
    /**
     * 专业分类名称
     */
    @TableField(exist = false)
    private String zyfl;
    /**
     * 培训类型代码
     */
    @TableField(exist = false)
    private String pxlxdm;
    /**
     * 考试类型
     */
    @TableField(exist = false)
    private String kslx;
    /**
     * 最小年龄
     */
    @TableField(exist = false)
    private String nlMin;
    /**
     * 最大年龄
     */
    @TableField(exist = false)
    private String nlMax;
    /**
     * 职务的字典值
     */
    @TableField(exist = false)
    private String[] dicValue;

    /**
     * 案处机构id
     */
    @TableField(exist = false)
    private String orgDealId;
    /**
     * 统计维度
     */
    @TableField(exist = false)
    private String tjwd;

    /**
     * 划分
     */
    @TableField(exist = false)
    private String hf;

    /**
     * 单位联系电话
     */
    @TableField(exist = false)
    private String  dwlxdh;

    /**
     * 修改之前的身份证号码
     */
    @TableField(exist = false)
    private String  oldSfzjhm;
    /**
     * 发证日期
     */
    @TableField(exist = false)
    private Date  fzrq;

    /**
     * 证件有效期起
     */
    @TableField(exist = false)
    private Date  yxqq;

    /**
     * 证件有效期止
     */
    @TableField(exist = false)
    private Date  yxqz;
    /* -----------------------------------------------------*/

    @Override
    public String getId() {
        return zfryxxId;
    }

    @Override
    public void setId(String id) {
        this.zfryxxId = id;
    }


}
