package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 分析研判系统对接数据
 *
 * @author 黄宇
 * @create 2020-05-12
 */
@Data
public class ZfRyDataVO implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 姓名
     */
    private String name;
    /**
     * 执法证号
     */
    private String id;
    /**
     * 电话号码
     */
    private String tel;
    /**
     * 组织机构名称
     */
    private String home;

    /**
     * 数据集合
     */
    private List<ZfRyDataVO> list;
    /**
     * 所在位置
     */
    private String address;
    /**
     * 所在部门
     */
    private String department;
    /**
     * 职务
     */
    private String work;
    /**
     * 证件有效期
     */
    private String time;
    /**
     * 执法区域
     */
    private String area;
    /**
     * 执法人员信息Id
     */
    private String zfryxxId;

    /**
     * 附件路径
     */
    private String bclj;

    /**
     * 请求参数
     */
    private String parameters;
    /**
     * 组织机构ID
     */
    private String orgId;
    /**
     * 组织机构名称
     */
    private String orgName;

    /**
     * 执法人员Id
     */
    private String zfryId;

    /**
     * 执法人员的执法证号
     */
    private String zfzh;

    /**
     * 执法人员性别
     */
    private String xb;

    /**
     * 执法人员性别Text
     */
    private String xbText;

    /**
     * 执法人员入职日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date rzrq;

    /**
     * 事件发生地距离执法人员距离
     */
    private String sjAndZfryDistance;
    /**
     * 删除标记
     */
    private String deleteFlag;
    /**
     * 身份证件号码
     */
    private String sfzjhm;
}
