package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 增加字段：所属单位、姓名、身份证号、民族、毕业时间、参加工作时间、从事执法时间、学历、专业、职务、执法岗位代码、资格证号或成绩、执法证号码、审批类型、审批结果
 * </p>
 *
 * @author 黄宇
 * @since 2020-03-24
 */
@Data
@TableName("ZFRYGL_J_SPB_ZFRY_GL")
public class SpbZfryGlVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 执法人员基本信息的唯一标识。
     */
    private String zfryxxId;

    /**
     * 人员审批表的唯一标识
     */
    private String ryspbId;

    /**
     * 审批类型代码
     */
    private String splxdm;

    /**
     * 所属机构名称
     */
    private String ssjgmc;

    /**
     * 执法人员的姓名。
     */
    private String xm;

    /**
     * 执法证号
     */
    private String zfzh;

    /**
     * 学历代码
     */
    private String xldm;

    /**
     * 人员职务的代码。
     */
    private String zwdm;

    /**
     * 人员所属民族的代码。
     */
    private String mzdm;

    /**
     * 人员的岗位代码。
     */
    private String gwdm;

    /**
     * 执法人员人员的身份证号码。
     */
    private String sfzjhm;

    /**
     * 执法人员的毕业专业。
     */
    private String byzy;

    /**
     * 执法人员的毕业日期。
     */
    private Date byrq;

    /**
     * 执法人员参加工作的起始日期。
     */
    private Date cjgzsj;

    /**
     * 执法人员从事执法工作的起始日期。
     */
    private Date cszfrq;

    /**
     * 审批结果：1不通过，2通过
     */
    private String spjg;
    /**
     * 上传附件的ID 用逗号隔开
     */
    private String scfj;


    /**                       表外字段                                        **/

    /**
     * 从事执法日期字符串
     */
    @TableField(exist = false)
    private  String cszfrqStr;
    /**
     * 参加工作时间
     */
    @TableField(exist = false)
    private  String cjgzsjStr;

    /**
     * 资格证书编号
     */
    @TableField(exist = false)
    private  String zgzsbh;
    /**
     * 判断是否审批过 1 审批
     */
    @TableField(exist = false)
    private String  flag;

    /**
     * 审批流程明细ID
     */
    @TableField(exist = false)
    private String  splcmxId;

    /**
     * 审批描述
     */
    @TableField(exist = false)
    private String spms;
    /**
     * 审批时间字符串
     */
    @TableField(exist = false)
    private String spsjStr;


    /**
     * 县级审批意见
     */
    @TableField(exist = false)
    private String xjspyj;

    /**
     * 县级审批人
     */
    @TableField(exist = false)
    private String xjspr;

    /**
     * 县级审批日期
     */
    @TableField(exist = false)
    private String xjsprqStr;

    /**
     * 市级审批意见
     */
    @TableField(exist = false)
    private String sjspyj;

    /**
     * 市级审批人
     */
    @TableField(exist = false)
    private String sjspr;

    /**
     * 市级审批日期
     */
    @TableField(exist = false)
    private String sjsprqStr;

    /**
     * 省级审批意见
     */
    @TableField(exist = false)
    private String sjspyjS;

    /**
     * 省级审批人
     */
    @TableField(exist = false)
    private String sjsprS;

    /**
     * 省级审批日期
     */
    @TableField(exist = false)
    private String sjsprqSStr;
    /**
     * 毕业时间
     */
    @TableField(exist = false)
    private String byrqStr;
    @Override
    public String getId() {
        return zfryxxId;
    }

    @Override
    public void setId(String id) {
        this.zfryxxId = id;
    }


}
