package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 审批流程明细
 * </p>
 *
 * @author 黄宇
 * @since 2020-03-29
 */
@Data
@TableName("ZFRYGL_J_SPLCMX")
public class SpLcMxVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 审批流程明细的唯一标识。
     */
    @TableId
    private String splcmxId;

    /**
     * 执法人员基本信息的唯一标识。
     */
    private String zfryxxId;

    /**
     * 审批类型代码
     */
    private String splxdm;

    /**
     * 组织机构ID
     */
    private String zzjgid;

    /**
     * 人员审批表的唯一标识
     */
    private String ryspbId;

    /**
     * 审批机构名称
     */
    private String spjgmc;

    /**
     * 审批时间
     */
    private Date spsj;

    /**
     * 审批结果：1不通过，2通过
     */
    private String spjg;

    /**
     * 审批描述
     */
    private String spms;
    /**
     * 当前组织机构ID
     */
    @TableField(exist = false)
    private String currentOrgId;

    @TableField(exist = false)
    private String orgLevel;
    /**
     * 资格准入审批
     */
    @TableField(exist = false)
    private List<SpLcMxVO> zgzrsp;
    /**
     * 发证审批
     */
    @TableField(exist = false)
    private List<SpLcMxVO> fzsp;
    /**
     * 审批时间
     */
    @TableField(exist = false)
    private String spsjStr;
    /**
     * 审批状态
     */
    @TableField(exist = false)
    private String spztdm;

    @Override
    public String getId() {
        return splcmxId;
    }

    @Override
    public void setId(String id) {
        this.splcmxId = id;
    }


}
