package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/**
 * <p>
 * 人员责任追究信息
 * </p>
 *
 * @author pt
 * @since 2020-03-21
 */
@Data
@TableName("ZFRYGL_J_RYZRZJXX")
public class RyzrzjxxVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 人员责任追究信息的唯一标识
     */
    @TableId
    private String ryzrzjxxId;

    /**
     * 过错类型代码
     */
    private String gclxdm;
    /**
     * 过错类型
     */
    @TableField(exist = false)
    private String gclxStr;

    /**
     * 追究方式代码
     */
    private String zjfsdm;
    /**
     * 追究方式
     */
    @TableField(exist = false)
    private String zjfsStr;
    /**
     * 责任信息的唯一标识
     */
    private String zrxxId;

    /**
     * 执法人员基本信息的唯一标识。
     */
    private String zfryxxId;

    /**
     * 多个执法人员基本信息的唯一标识。
     */
    @TableField(exist = false)
    private String[] zfryxxIds;

    /**
     * 姓名
     */
    private String xm;

    /**
     * 执法证号
     */
    private String zfzh;

    /**
     * 所属机构
     */
    private String ssjg;

    /**
     * 过错描述
     */
    private String gcms;

    /**
     * 追究次数
     */
    @TableField(exist = false)
    private String cs;
    /**
     * 责任事故名称
     */
    @TableField(exist = false)
    private String zrsgmc;
    /**
     * 责任发生时间
     */
    @TableField(exist = false)
    private String fssj;
    /**
     * 责任分类
     */
    @TableField(exist = false)
    private String zfzrfldm;
    /**
     * 用于责任追究判断是否可移除选择的人员
     */
    @TableField(exist = false)
    private String shnyc;

    @Override
    public String getId() {
        return ryzrzjxxId;
    }

    @Override
    public void setId(String id) {
        this.ryzrzjxxId = id;
    }


}

