package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 人员变动信息
 * </p>
 *
 * @author pt
 * @since 2020-03-20
 */
@Data
@TableName("ZFRYGL_J_RYBDXX")
public class RybdxxVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 人员变动信息的唯一标识
     */
    @TableId
    private String rybdxxId;
    /**
     * 当前用户组织机构id
     */
    private String zzjgId;
    /**
     * 人员姓名
     */
    @TableField(exist = false)
    private String xm;

    /**
     * 执法证号
     */
    @TableField(exist = false)
    private String zfzh;

    /**
     * 调动前执法人员执法门类的代码。
     */
    private String zfmldmDdq;

    /**
     * 调动状态代码
     */
    private String ddztdm;
    /**
     * 调动状态名称
     */
    @TableField(exist = false)
    private String ddzt;

    /**
     * 调动前组织机构ID
     */
    private String zzjgidDdq;

    /**
     * 调动后执法人员执法门类的代码。
     */
    private String zfmldmDdh;
    /**
     * 调动前岗位代码
     */
    private String gwdmDdq;
    /**
     * 调动后岗位代码
     */
    private String gwdmDdh;

    /**
     * 执法人员基本信息的唯一标识。
     */
    private String zfryxxId;

    /**
     * 调动后组织机构ID
     */
    private String zzjgidDdh;

    /**
     * 变动类型代码
     */
    private String bdlxdm;

    /**
     * 调入前人员职务的代码。
     */
    private String zwdmDdq;

    /**
     * 调入后人员职务的代码。
     */
    private String zwdmDdh;

    /**
     * 调入前执法区域
     */
    private String drqzfqy;

    /**
     * 调入后执法区域
     */
    private String drhzfqy;

    /**
     * 调动原因
     */
    private String ddyy;

    /**
     * 申请时间
     */
    private Date sqsj;

    /**
     * 变动时间
     */
    private Date bdsj;

    /**
     * 拒绝原因
     */
    private String jjyy;

    /**
     * 信息修改状态：0 未修改 1 已修改
     */
    private String xxxgzt;
    /**
     * 身份证件号
     */
    @TableField(exist = false)
    private String sfzjhm;
    /**
     * 返回失败的身份证号
     */
    @TableField(exist = false)
    private List<String> listAllDistinct;

    /**
     * 导入成功总数
     */
    @TableField(exist = false)
    private int daoRuCount;
    /**
     * 导入失败总数
     */
    @TableField(exist = false)
    private int faileCount;


    @Override
    public String getId() {
        return rybdxxId;
    }

    @Override
    public void setId(String id) {
        this.rybdxxId = id;
    }

}
