package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.Date;


/**
 * <p>
 * 人员审批表
 * </p>
 *
 * @author 黄宇
 * @since 2020-03-20
 */
@Data
@TableName("ZFRYGL_J_RYSPB")
public class RySpbVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 人员审批表的唯一标识
     */
    @TableId
    private String ryspbId;

    /**
     * 审批类型代码
     */
    private String splxdm;

    /**
     * 审批状态代码
     */
    private String spztdm;

    /**
     * 待审批机构ID
     */
    private String zzjgidDshjg;

    /**
     * 填报日期
     */
    private Date tbrq;

    /**
     * 填报人姓名
     */
    private String tbr;

    /**
     * 填报单位
     */
    private String tbdw;

    /**
     * 参与审批的机构的编号，以逗号隔开
     */
    private String syspjg;

    /**
     * 申请人数
     */
    private Integer sqrs;

    /**
     * 通过人数
     */
    private Integer tgrs;

    /**
     * 县级审批机构ID
     */
    private String zzjgidXj;

    /**
     * 县级审批意见
     */
    private String xjspyj;

    /**
     * 县级审批人
     */
    private String xjspr;

    /**
     * 县级审批日期
     */
    private Date xjsprq;

    /**
         * 市级审批机构ID
     */
    private String zzjgidSj;

    /**
     * 市级审批意见
     */
    private String sjspyj;

    /**
     * 市级审批人
     */
    private String sjspr;

    /**
     * 市级审批日期
     */
    private Date sjsprq;

    /**
     * 发证机关审批意见
     */
    private String fzjgspyj;

    /**
     * 发证机关审批人
     */
    private String fzjgspr;

    /**
     * 发证机关审批日期
     */
    private Date fzjgsprq;
    /**
     * 填报单位ID
     */
    private String tbdwId;
    /**
     * 填报人ID
     */
    private String tbrId;
    /**
     * 县级审批人Id
     */
    private String xjsprId;
    /**
     * 县级负责人
     */
    private String xjfzr;
    /**
     * 市级审批人ID
     */
    private String sjsprId;
    /**
     * 市级负责人
     */
    private String sjfzr;
    /**
     * 发证机关审批人ID
     */
    private String fzjgsprId;
    /**
     * 发证机关负责人
     */
    private String fzjgfzr;

    /**
     * 发证机关id
     */
    private String zzjgidFzjg;
    /**
     * 锁定状态：0未锁定，1已锁定
     */
    private String sdzt;
    /**
     * 锁定人姓名
     */
    private String sdrxm;
    /**
     * 锁定人姓名
     */
    private String sdrId;


    /**                 表外字段                **/
    /**
     * 执法人员信息ID
     */
    @TableField(exist = false)
    private  String zfryxxId;

    /**
     * 填报起始日期
     */
    @TableField(exist = false)
    private String tbrqStart;
    /**
     * 填报结束日期
     */
    @TableField(exist = false)
    private String tbrqEnd;
    /**
     * 填报日期字符串
     */
    @TableField(exist = false)
    private String tbrqStr;
    /**
     * 查询范围
     */
    @TableField(exist = false)
    private String cxfw;
    /**
     * 用户组织机构
     */
    @TableField(exist = false)
    private String orgID;

    /**
     * 组织机构名称
     */
    @TableField(exist = false)
    private String orgName;

    @TableField(exist = false)
    private String orgLevel;
    /**
     * 审批类型代码字典值
     */
    @TableField(exist = false)
    private String splxdmCode;
    /**
     * 县级审批日期
     */
    @TableField(exist = false)
    private String xjsprqStr;
    /**
      * 市级审批日期
     */
    @TableField(exist = false)
    private String sjsprqStr;

    /**
     * 省级审批日期
     */
    @TableField(exist = false)
    private String sjsprqSStr;
    /**
     * 审批标记
     */
    @TableField(exist = false)
    private String spflag;
    /**
     * 审批状态字典值
     */
    @TableField(exist = false)
    private String spztdmCode;
    /**
     * 发证机关审批日期字符串
     */
    @TableField(exist = false)
    private String  fzjgsprqStr;
    /**
     * 审批按钮的显示 1 显示
     */
    @TableField(exist = false)
    private String  isShow;
    @TableField(exist = false)
    private String  orgCode;

    @Override
    public String getId() {
        return ryspbId;
    }

    @Override
    public void setId(String id) {
        this.ryspbId = id;
    }


}
