package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;


/**
 * <p>
 * 人员培训信息
 * </p>
 *
 * @author 黄宇
 * @since 2020-03-21
 */
@Data
@TableName("ZFRYGL_J_RYPXXX")
public class RyPxXxVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 人员培训信息的唯一标识。
     */
    @TableId
    private String rypxxxId;

    /**
     * 培训类型代码
     */
    private String pxlxdm;

    /**
     * 执法人员基本信息的唯一标识。
     */
    private String zfryxxId;

    /**
     * 附加信息数据来源代码
     */
    private String fjxxsjlydm;

    /**
     * 培训开始时间
     */
    @DateTimeFormat(pattern ="yyyy-MM-dd HH:mm:ss")
    private Date pxksrq;

    /**
     * 培训结束时间
     */
    @DateTimeFormat(pattern ="yyyy-MM-dd HH:mm:ss")
    private Date pxjssj;

    /**
     * 证书编号
     */
    private String zsbh;

    /**
     * 证书名称
     */
    private String zsmc;

    /**
     * 培训机构
     */
    private String pxjgmc;

    /**
     * 培训结果：0 不合格 1 合格
     */
    private String pxjg;

    /**
     * 所获学分
     */
    private String shxf;

    /**
     * 备注
     */
    private String bz;
    /**
     *
     */

    /**                   表外字段                   **/
    /**
     * wo
     */
    @TableField(exist = false)
    private String pxrqStrt;
    /**
     * 培训结束时间
     */
    @TableField(exist = false)
    private String pxrqEnd;

    /**
     * 培训时间  开始和结束时间合并 ~
     */
    @TableField(exist = false)
    private String pxsj;
    /**
     * 身份证件号码
     */
    @TableField(exist = false)
    private String sfzjhm;


    /**jqq            表外字段：申报审核           **/

    /**
     * 审核日期
     */
    @TableField(exist = false)
    private  Date shrq;
    /**
     * 所获学时
     */
    @TableField(exist = false)
    private String zxs;
    /**
     * 学分申报信息ID
     */
    @TableField(exist = false)
    private String xfsbxxId;
    /**
     * 操作
     */
    @TableField(exist = false)
    private String cz;

    /**
     * 人员培训信息Excel数据
     */
    @TableField(exist = false)
    private List<RyPxXxVO> ryPxXxList;
    /**
     * 人员培训信息Excel数据不符合要求
     */
    @TableField(exist = false)
    private List<String> failRyPxInfo;

    /**
     *excel导入数据为空提示
     */
    @TableField(exist = false)
    private String excelDataNull;
    /**
     * 身份证号码不符合要求
     */
    @TableField(exist = false)
    private List<String> failSfZhM;

    @Override
    public String getId() {
        return rypxxxId;
    }

    @Override
    public void setId(String id) {
        this.rypxxxId = id;
    }


}
