package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 人员考试信息
 * </p>
 *
 * @author 黄宇
 * @since 2020-03-21
 */
@Data
@TableName("ZFRYGL_J_RYKSXX")
public class RyKsXxVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 人员考试信息的唯一标识。
     */
    @TableId
    private String ryksxxId;

    /**
     * 考试类型代码
     */
    private String kslxdm;

    /**
     * 附加信息数据来源代码
     */
    private String fjxxsjlydm;

    /**
     * 执法人员基本信息的唯一标识。
     */
    private String zfryxxId;

    /**
     * 考试日期
     */
    private Date ksrq;

    /**
     * 考试成绩
     */
    private String kscj;

    /**
     * 考试机构
     */
    private String ksjg;

    /**
     * 是否通过，1是0否
     */
    private String sfTg;

    /**
     * 备注
     */
    private String bz;

    /**       表外字段          **/

    /**
     * 考试日期
     */
    @TableField(exist = false)
    private String  ksrqStr;
    /**
     * 身份证件号码
     */
    @TableField(exist = false)
    private String  sfzjhm;

    /**
     * 人员考试信息Excel数据
     */
    @TableField(exist = false)
    private List<RyKsXxVO> ryKsXxList;
    /**
     * 人员考试信息Excel数据不符合要求
     */
    @TableField(exist = false)
    private List<String> failRyKsInfo;

    /**
     *excel导入数据为空提示
     */
    @TableField(exist = false)
    private String excelDataNull;
    /**
     * 身份证号码不符合要求
     */
    @TableField(exist = false)
    private List<String> failSfZhM;

    @Override
    public String getId() {
        return ryksxxId;
    }

    @Override
    public void setId(String id) {
        this.ryksxxId = id;
    }


}
