package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 人员教育信息
 * </p>
 *
 * @author 黄宇
 * @since 2020-03-20
 */
@Data
@TableName("ZFRYGL_J_RYJYXX")
public class RyJyXxVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 人员教育信息的唯一标识。
     */
    @TableId
    private String ryjyxxId;

    /**
     * 附加信息数据来源代码
     */
    private String fjxxsjlydm;

    /**
     * 学历代码
     */
    private String xldm;

    /**
     * 执法人员基本信息的唯一标识。
     */
    private String zfryxxId;

    /**
     * 执法人员的毕业日期。
     */
    private Date byrq;

    /**
     * 执法人员的毕业学校。
     */
    private String byxx;

    /**
     * 执法人员的毕业专业。
     */
    private String byzy;

    /**
     * 备注
     */
    private String bz;

    /**                 外部字段               **/
    /**
     * 毕业日期
     */
    @TableField(exist = false)
    private String byrqStr;
    /**
     * 人员教育信息ID数组
     */
    @TableField(exist = false)
    private String []ryjyxxIdArr;

    /**
     * 学历代码文字
     */
    @TableField(exist = false)
    private String xldmWz;
    /**
     * 身份证件号码
     */
    @TableField(exist = false)
    private String sfzjhm;

    /**
     * 人员教育信息Excel数据
     */
    @TableField(exist = false)
    private List<RyJyXxVO> ryJyXxList;
    /**
     * 人员教育信息Excel数据不符合要求
     */
    @TableField(exist = false)
    private List<String> failRyJyInfo;

    /**
     *excel导入数据为空提示
     */
    @TableField(exist = false)
    private String excelDataNull;
    /**
     * 身份证号码不符合要求
     */
    @TableField(exist = false)
    private List<String> failSfZhM;
    @Override
    public String getId() {
        return ryjyxxId;
    }

    @Override
    public void setId(String id) {
        this.ryjyxxId = id;
    }


}
