package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 人员奖励信息
 * </p>
 *
 * @author 黄宇
 * @since 2020-03-21
 */
@Data
@TableName("ZFRYGL_J_RYJLXX")
public class RyJlXxVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 人员奖励信息的唯一标识。
     */
    @TableId
    private String ryjlxxId;

    /**
     * 奖励类型代码
     */
    private String jllxdm;

    /**
     * 附加信息数据来源代码
     */
    private String fjxxsjlydm;

    /**
     * 执法人员基本信息的唯一标识。
     */
    private String zfryxxId;

    /**
     * 奖励日期
     */
    @JSONField(format = "yyyy-MM-dd")
    private Date jlrq;

    /**
     * 奖励描述
     */
    private String jlms;
    /**              表外字段      ***/

    /**
     * 奖励日期
     */
    @TableField(exist = false)
    private  String jlrqStr;
    /**
     * 身份证件号码
     */
    @TableField(exist = false)
    private  String sfzjhm;

    /**
     * 人员考试信息Excel数据
     */
    @TableField(exist = false)
    private List<RyJlXxVO> ryJlXxList;
    /**
     * 人员考试信息Excel数据不符合要求
     */
    @TableField(exist = false)
    private List<String> failRyJlInfo;

    /**
     *excel导入数据为空提示
     */
    @TableField(exist = false)
    private String excelDataNull;
    /**
     * 奖励次数-证件审核用
     */
    @TableField(exist = false)
    private String cs;
    /**
     * 身份证号码不符合要求
     */
    @TableField(exist = false)
    private List<String> failSfZhM;

    @Override
    public String getId() {
        return ryjlxxId;
    }

    @Override
    public void setId(String id) {
        this.ryjlxxId = id;
    }


}
