package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 人员惩罚信息
 * </p>
 *
 * @author 黄宇
 * @since 2020-03-21
 */
@Data
@TableName("ZFRYGL_J_RYCFXX")
public class RyCfXxVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 人员惩罚信息的唯一标识。
     */
    @TableId
    private String rycfxxId;

    /**
     * 执法人员基本信息的唯一标识。
     */
    private String zfryxxId;

    /**
     * 附加信息数据来源代码
     */
    private String fjxxsjlydm;

    /**
     * 惩罚类型代码
     */
    private String cflxdm;

    /**
     * 惩罚日期
     */
    @JSONField(format = "yyyy-MM-dd")
    private Date cfrq;

    /**
     * 惩罚描述
     */
    private String cfms;

    /**          表外字段                     **/

    /**
     * 惩罚日期
     */
    @TableField(exist = false)
    private String cfrqStr;
    /**
     * 身份证件号码
     */
    @TableField(exist = false)
    private String sfzjhm;
    /**
     * 人员惩罚信息Excel数据
     */
    @TableField(exist = false)
    private List<RyCfXxVO> ryCfXxList;
    /**
     * 人员惩罚信息Excel数据不符合要求
     */
    @TableField(exist = false)
    private List<String> failRyCfInfo;

    /**
     * excel导入数据为空提示
     */
    @TableField(exist = false)
    private String excelDataNull;

    /**
     * 惩罚次数
     */
    @TableField(exist = false)
    private String cs;

    /**
     * 身份证号码不符合要求
     */
    @TableField(exist = false)
    private List<String> failSfZhM;
    @Override
    public String getId() {
        return rycfxxId;
    }

    @Override
    public void setId(String id) {
        this.rycfxxId = id;
    }


}
