package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 考核记录表
 * </p>
 *
 * @author 黄宇
 * @since 2020-05-07
 */
@Data
@TableName("ZFRYGL_J_KHJLB")
public class KhJlBVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 考核记录表的唯一标识
     */
    @TableId
    private String khjlbId;

    /**
     * 执法人员基本信息的唯一标识。
     */
    private String zfryxxId;

    /**
     * 考核标准的ID，与版本号组合主键
     */
    private String khbzId;

    /**
     * 考核标准版本号
     */
    private String bbh;

    /**
     * 考核年度
     */
    private String khnd;

    /**
     * 考核时间
     */
    private Date khsj;
    /**
     * 考核人员姓名，多个逗号隔开
     */
    private String khry;

    /**
     * 总分
     */
    private Float zf;

    /**
     * 考核得分
     */
    private Float khdf;

    /**
     * 考核结果：A,B,C,D
     */
    private String khjg;

    /**
     * 被考核人意见
     */
    private String bkhryj;

    /**
     * 被考核人签字日期
     */
    private Date bkhrqzrq;

    /**
     * 考核人签字
     */
    private String khrqz;

    /**
     * 考核人签字日期
     */
    private Date khrqzrq;
    /**
     * 考核单位Id
     */
    private String khdwId;
    /**
     * 考核单位名称
     */
    private String khdwmc;
    /**
     * 被考核人员单位Id
     */
    private String bkhrydwId;
    /**
     * 被考核人员单位名称
     */
    private String bkhrydwmc;
    /**                表外字段                          **/
    /**
     * 姓名
     */
    @TableField(exist = false)
    private String xm;
    /**
     * 性别代码
     */
    @TableField(exist = false)
    private String xbdm;
    /**
     * 职务代码
     */
    @TableField(exist = false)
    private String zwdm;
    /**
     * 执法门类代码
     */
    @TableField(exist = false)
    private String zfmldm;
    /**
     * 执法证号
     */
    @TableField(exist = false)
    private String zfzh;
    /**
     * 查询范围
     */
    @TableField(exist = false)
    private String cxfw;

    /**
     * 证件状态代码
     */
    @TableField(exist = false)
    private String zjztdm;

    /**
     * 组织机构ID
     */
    @TableField(exist = false)
    private String zzjgid;
    /**
     * 组织机构名称
     */
    @TableField(exist = false)
    private String orgName;

    /**
     * 是否考核
     */
    @TableField(exist = false)
    private String  sfkh;
    /**
     * 考核人员考核记录关联集合
     */
    @TableField(exist = false)
    private List<KhJlKhXmGlVO> KhJlKhXmGlVOList;
    /**
     * 考核时间字符串
     */
    @TableField(exist = false)
    private String khsjStr;

    /**
     * 被考核人签字时间字符串
     */
    @TableField(exist = false)
    private String bkhrqzrqStr;
    /**
     * 考核人签字时间字符串
     */
    @TableField(exist = false)
    private String    khrqzrqStr;
    /**
     * 考核结果
     */
    @TableField(exist = false)
    private String khdfresult;

    @Override
    public String getId() {
        return khjlbId;
    }

    @Override
    public void setId(String id) {
        this.khjlbId = id;
    }


}
