package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.pxgl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.pxgl.entity.ZfryKjfjGlVO;

import java.util.List;

/**
 * <p>
 * 执法人员课件附件的下载信息 服务类
 * </p>
 *
 * @author LSH
 * @since 2020-07-03
 */
public interface ZfryKjfjGlService {

    /**
     * 新增执法人员课件附件的下载信息信息
     *
     * @param zfryKjfjGl
     * @return
     */
    boolean insert(ZfryKjfjGlVO zfryKjfjGl);

    /**
     * 修改执法人员课件附件的下载信息信息
     *
     * @param zfryKjfjGl
     * @return
     */
    boolean updateById(ZfryKjfjGlVO zfryKjfjGl);

    /**
     * 根据ID删除执法人员课件附件的下载信息信息
     *
     * @param id 　执法人员课件附件的下载信息ID
     * @return
     */
    boolean deleteById(String id);

    /**
     * 根据ID获取执法人员课件附件的下载信息信息
     *
     * @param id
     * @return
     */
    ZfryKjfjGlVO getById(String id);


    /**
     * 分页查询
     *
     * @param current    当前页
     * @param size       每页显示条数
     * @param zfryKjfjGl
     * @return
     */
    Page<ZfryKjfjGlVO> page(long current, long size, ZfryKjfjGlVO zfryKjfjGl);

    /**
     * 根据主键查询
     *
     * @param zfryxxId 执法人员id
     * @param kjfjxxId 课件附件信息ID
     * @param kcxxId   课程信息ID
     * @param kjxxId   课件信息ID
     * @return
     */
    ZfryKjfjGlVO queryByPrimary(String zfryxxId, String kjfjxxId, String kcxxId, String kjxxId);

    /**
     * 根据主键更新
     *
     * @param zfryKjfjGlVO
     * @return
     */
    boolean updateByPrimary(ZfryKjfjGlVO zfryKjfjGlVO);


    /**
     * 保存课件学习位置
     *
     * @param zfryKjfjGlVO
     * @return
     */
    boolean saveXxwz(ZfryKjfjGlVO zfryKjfjGlVO);

    /**
     * 批量删除下载记录
     *
     * @param sysUser
     * @param kjfjstrs
     * @return
     */
    boolean updateDownLoadInfo(SysUser sysUser, String[] kjfjstrs);

    /**
     * 保存可见附件学分
     *
     * @param zfryKjfjGlVO
     * @return
     */
    boolean obtainXf(ZfryKjfjGlVO zfryKjfjGlVO);

    /**
     * 查询当前用户的下载信息
     *
     * @param zfryxxId
     * @param fileType
     * @return
     */
    List<ZfryKjfjGlVO> getDownLoadInfoById(String zfryxxId, String fileType);

    /**
     * 查询当前用户的该课件的下载信息
     *
     * @param zfryxxId
     * @param kjxxId
     * @return
     */
    List<ZfryKjfjGlVO> getDownLoadInfoByKjId(String zfryxxId, String kjxxId);

    /**
     * 保存当前用户的下载信息
     *
     * @param zfryxxId
     * @param zfryKjfjGlVO
     * @return
     */
    boolean saveDownLoadInfo(String zfryxxId, ZfryKjfjGlVO zfryKjfjGlVO);

    /**
     * app端获取课件附件学习位置
     *
     * @param zfryxxId 执法人员id
     * @param kjfjxxId 课件附件id
     * @param kjxxId   课件信息id
     * @param kcxxId   课程信息id
     * @return
     */
    ZfryKjfjGlVO getXxwz(String zfryxxId, String kjfjxxId, String kjxxId, String kcxxId);
}

