package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.pxgl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.pxgl.entity.ZfryKjGlVO;

/**
 * <p>
 * 执法人员课件的学习状态 服务类
 * </p>
 *
 * @author LSH
 * @since 2020-07-05
 */
public interface ZfryKjGlService {

    /**
     * 新增执法人员课件的学习状态信息
     *
     * @param zfryKjGl
     * @return
     */
    boolean insert(ZfryKjGlVO zfryKjGl);

    /**
     * 修改执法人员课件的学习状态信息
     *
     * @param zfryKjGl
     * @return
     */
    boolean updateById(ZfryKjGlVO zfryKjGl);

    /**
     * 根据ID删除执法人员课件的学习状态信息
     *
     * @param id　执法人员课件的学习状态ID
     * @return
     */
    boolean deleteById(String id);

    /**
     * 根据ID获取执法人员课件的学习状态信息
     *
     * @param id
     * @return
     */
    ZfryKjGlVO getById(String id);


    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @param zfryKjGl
     * @return
     */
    Page<ZfryKjGlVO> page(long current, long size, ZfryKjGlVO zfryKjGl);

}

