package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.pxgl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.road.entity.HdVo;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.pxgl.entity.ZfryKcGlVO;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 执法人员课程的学习状态、点赞状态 服务类
 * </p>
 *
 * @author LSH
 * @since 2020-07-03
 */
public interface ZfryKcGlService {

    /**
     * 新增执法人员课程的学习状态、点赞状态信息
     *
     * @param zfryKcGl
     * @return
     */
    boolean insert(ZfryKcGlVO zfryKcGl);

    /**
     * 修改执法人员课程的学习状态、点赞状态信息
     *
     * @param zfryKcGl
     * @return
     */
    boolean updateById(ZfryKcGlVO zfryKcGl);

    /**
     * 根据ID删除执法人员课程的学习状态、点赞状态信息
     *
     * @param id 　执法人员课程的学习状态、点赞状态ID
     * @return
     */
    boolean deleteById(String id);

    /**
     * 根据ID获取执法人员课程的学习状态、点赞状态信息
     *
     * @param id
     * @return
     */
    ZfryKcGlVO getById(String id);


    /**
     * 分页查询
     *
     * @param current  当前页
     * @param size     每页显示条数
     * @param zfryKcGl
     * @return
     */
    Page<ZfryKcGlVO> page(long current, long size, ZfryKcGlVO zfryKcGl);

    /**
     * 根据主键查询
     *
     * @param zfryxxId 执法人员id
     * @param kcxxId   课程信息id
     * @return
     */
    ZfryKcGlVO queryByPrimary(String zfryxxId, String kcxxId);

    /**
     * 根据主键更新
     *
     * @param zfryKcGlVO
     * @return
     */
    boolean updateByPrimary(ZfryKcGlVO zfryKcGlVO);

    /**
     * 保存执法人员课程关联
     *
     * @param zfryKcGlVO
     * @return
     */
    BigDecimal saveZfryKcGl(ZfryKcGlVO zfryKcGlVO, String type, SysUser curUser);

    /**
     * 页面分页查询
     *
     * @param zfryKcGl
     * @return
     */
    Page<ZfryKcGlVO> queryPage( Page<ZfryKcGlVO> page, ZfryKcGlVO zfryKcGl, String curUserOrgId);

    /*****
     * 导出查询
     * @param entity 实体类
     * @param ids 主键集合
     * @return
     */
    public List<ZfryKcGlVO> export(ZfryKcGlVO entity, String ids);
}

