package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.pxgl.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.pxgl.entity.ZfpxglJXfsbxxVo;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity.RyPxXxVO;

import java.util.List;

/**
 * <p>
 * 学分申报信息 服务类
 * </p>
 *
 * @author jqq
 * @since 2020-05-12
 */
public interface ZfpxglJXfsbxxService {

    /**
     * 根据ids查询
     *
     * @param list
     * @return
     */
    List<ZfpxglJXfsbxxVo> getInfoByIds(List<String> list);


    /**
     * 查看--根据学分申报信息ID获取详情
     *
     * @param id
     * @return
     */
    ZfpxglJXfsbxxVo getInfoById(String id);

    /**
     * 分页查询
     *
     * @param current
     * @param size
     * @param xm      姓名
     * @param pxmc    培训名称
     * @param sbzt    申报状态
     * @param orgId   当前用户所在机构
     * @return
     */
    Page<ZfpxglJXfsbxxVo> page(long current, long size, String xm, String pxmc, String sbzt, String orgId);

    /**
     * 批量审核
     *
     * @param sbzt      申报状态
     * @param bz        备注
     * @param zxs       总学时
     * @param zxf       总学分
     * @param xfsbxxIds 学分申报信息ids
     * @param curUser
     * @return
     */
    boolean plShenhe(String sbzt, String bz, String zxs, String zxf, String[] xfsbxxIds, SysUser curUser);

    /**
     * 申报审核
     * 插入--申报操作记录表
     * 插入--人员培训信息表
     *
     * @param ryPxXxVO
     * @param curUser
     * @return
     */
    boolean insertSbsh(RyPxXxVO ryPxXxVO, SysUser curUser);
}

