package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.pxgl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.pxgl.entity.ZfpxglJXfjl;

/**
 * <p>
 * 学分记录 服务类
 * </p>
 *
 * @author jqq
 * @since 2020-06-01
 */
public interface ZfpxglJXfjlService {

    /**
     * 新增学分记录信息
     *
     * @param zfpxglJXfjl
     * @return
     */
    boolean insert(ZfpxglJXfjl zfpxglJXfjl);

    /**
     * 修改学分记录信息
     *
     * @param zfpxglJXfjl
     * @return
     */
    boolean updateById(ZfpxglJXfjl zfpxglJXfjl);

    /**
     * 根据ID删除学分记录信息
     *
     * @param id　学分记录ID
     * @return
     */
    boolean deleteById(String id);

    /**
     * 根据ID获取学分记录信息
     *
     * @param id
     * @return
     */
    ZfpxglJXfjl getById(String id);


    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @param zfpxglJXfjl
     * @return
     */
    Page<ZfpxglJXfjl> page(long current, long size, ZfpxglJXfjl zfpxglJXfjl);

    /**
     * 查询获取途径的学分记录
     * @param zfryxxId 执法人员信息id
     * @param ndxfjlId 年度学分记录id
     * @param hqtj 获取途径码值
     * @return
     */
    public Integer queryXfjlByHqtj(String zfryxxId,String ndxfjlId,String hqtj);

  


}

