package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.pxgl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.pxgl.entity.*;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author : jqq
 * @Description ：培训批次service接口
 * @date : 2020/5/30 13:40
 **/
public interface ZfpxglJPxpcglService {
    /**
     * 分页查询培训批次信息
     *
     * @param current         当前页
     * @param size            每页显示条数
     * @param zfpxglJPxpcXxVO 培训批次信息
     * @return
     */
    Page<ZfpxglJPxpcXxVO> page(long current, long size, ZfpxglJPxpcXxVO zfpxglJPxpcXxVO);
    /**
     * 监督评议查询培训批次数
     * @param page
     * @param zfpxglJPxpcXxVO
     * @return
     */
    Page<ZfpxglJPxpcXxVO> jdpyPxpcpage(Page page,ZfpxglJPxpcXxVO zfpxglJPxpcXxVO);

    /**
     * 线下培训批次
     * @param current
     * @param size
     * @param zfpxglJPxpcXxVO
     * @return
     */
    Page<ZfpxglJPxpcXxVO> xxpxPage(long current, long size, ZfpxglJPxpcXxVO zfpxglJPxpcXxVO);

    /**
     * 根据培训计划id查询培训计划信息
     *
     * @param pxjhId 培训计划id
     * @return
     */
    ZfpxglJPxjhVO getPxjhById(String pxjhId);

    /**
     * 根据nd获取当前组织机构培训计划名称列表
     *
     * @param nd    年度
     * @param orgId 组织机构
     * @return
     */
    List<ZfpxglJPxjhVO> getPxjhByNd(String nd, String orgId);

    /**
     * 根据nd获取当前年度该培训计划的最大培训批次
     *
     * @param pxjhId 培训计划id
     * @return
     */
    Map<String, BigDecimal> getMaxPc(String pxjhId);

    /**
     * 根据培训批次信息id获取课程列表
     *
     * @param pxpcxxId 培训批次信息id
     * @return
     */
    Page<ZfpxglJXxpxkcVo> pagePxkc(long current, long size, String pxpcxxId);

    /**
     * 删除培训批次信息
     *
     * @param list 培训批次信息ids
     * @return
     */
    boolean deletePxpcxx(List<String> list, SysUser curUser);

    /**
     * 人员列表回显
     *
     * @param pxpcxxId 培训批次信息id
     * @return
     */
    List<PxpcRyGlVo> pageRy(String pxpcxxId);

    /**
     * 1.插入培训批次基本信息
     * 2.插入培训批次人员关联
     * 3.判断学分年度记录是否存在，存在更新，不存在添加
     * 4.添加学分记录
     * 5.岗前培训，资格审批通过'11'或培训中'20'，修改对应审批状态为对应培训结果
     * 6.添加线下培训课程
     *
     * @param zfpxglJPxpcXxVO 培训批次信息
     * @param curUser
     * @return
     */
    boolean insertAll(ZfpxglJPxpcXxVO zfpxglJPxpcXxVO, SysUser curUser);

    /**
     * 获取培训批次信息
     *
     * @param pxpcxxId 培训批次信息id
     * @return
     */
    ZfpxglJPxpcXxVO getPxpcxxById(String pxpcxxId);

    /**
     * 参训人员导出数据
     *
     * @param pxpcxxId  培训批次信息id
     * @param zfryxxIds 执法人员信息ids
     * @return
     */
    List<ExportPxpcRyGl> daochuPxpcRyGl(String pxpcxxId, String[] zfryxxIds);

    /**
     * 更新培训批次
     *
     * @param zfpxglJPxpcXxVO 培训批次信息
     * @param curUser
     * @return
     */
    boolean updatePxpc(ZfpxglJPxpcXxVO zfpxglJPxpcXxVO, SysUser curUser);
    /**
     * 首页线下培训信息查询
     * @param cxfw
     * @param sj
     * @param curUser
     */
    SyPxInfoVO querySyPxInfo(String cxfw, String sj, SysUser curUser);

    /**
     * 查询线下培训柱状图表
     * @param mp
     * @return
     */
    List<Map<String,Object>> queryXxpxEchartsInfo(Map<String,Object> mp);

    /**
     * 查询培训人次饼状图
     * @param mp
     * @return
     */
    List<Map<String,Object>> queryPxrcEchartsInfo(Map<String,Object> mp);

    /**
     * 查询监督评议培训统计
     * @param mp
     * @return
     */
    Map<String,Object> queryPxtj(Map<String,Object> mp);
    /**
     * 监督评议-培训计划统计
     * @param page
     * @param zfpxglJPxjhVO
     * @return
     */
    Page<ZfpxglJPxjhVO>  jdpyPxjhpage(Page page,  ZfpxglJPxjhVO zfpxglJPxjhVO);
}
