package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.pxgl.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.pxgl.entity.PxglJNdxfjl;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.pxgl.entity.ZfpxglJXfjl;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 年度学分记录 服务类
 * </p>
 *
 * @author pt
 * @since 2020-05-06
 */
public interface ZfpxglJNdxfjlService {

    /**
     * 新增年度学分记录信息
     *
     * @param zfpxglJNdxfjl
     * @return
     */
    boolean insert(PxglJNdxfjl zfpxglJNdxfjl);

    /**
     * 修改年度学分记录信息
     *
     * @param zfpxglJNdxfjl
     * @return
     */
    boolean updateById(PxglJNdxfjl zfpxglJNdxfjl);

    /**
     * 根据ID删除年度学分记录信息
     *
     * @param id 　年度学分记录ID
     * @return
     */
    boolean deleteById(String id);

    /**
     * 根据ID获取年度学分记录信息
     *
     * @param id
     * @return
     */
    PxglJNdxfjl getById(String id);

    /**
     * 根据ID获取年度学分记录信息
     *
     * @param id
     * @return
     */
    PxglJNdxfjl getndxfjlById(String id);


    /**
     * 分页查询
     *
     * @param current       当前页
     * @param size          每页显示条数
     * @param zfpxglJNdxfjl
     * @return
     */
    Page<PxglJNdxfjl> page(long current, long size, PxglJNdxfjl zfpxglJNdxfjl);

    /**
     * 学分获取详情页面分页查询
     *
     * @param current     当前页
     * @param size        每页显示条数
     * @param zfpxglJXfjl
     * @return
     */
    Page<ZfpxglJXfjl> xfjlxqpage(long current, long size, ZfpxglJXfjl zfpxglJXfjl);

    /**
     * 根据年度和人员id查询是否存在年度学分记录
     *
     * @param nd
     * @param zfryxxId
     * @return
     */
    PxglJNdxfjl queryNdxfjlByNd(String nd, String zfryxxId);

    /**
     * 通过userID查询用户信息判断是否为执法人员
     *
     * @param userId
     * @return
     */
    SysUser queryById(String userId);

    /**
     * 查询学分达标饼状图
     * @param mp
     * @return
     */
    List<Map<String,Object>> queryNdxfEchartInfo( Map<String,Object> mp);

    /**
     * 查询近三年
     * @return
     */
    List<String> queryYearList();

}

