package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.pxgl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.pxgl.entity.ZfpxglJKcdjjl;

import java.util.List;

/**
 * <p>
 * 课程点击记录 服务类
 * </p>
 *
 * @author LSH
 * @since 2020-08-31
 */
public interface ZfpxglJKcdjjlService {

    /**
     * 新增课程点击记录信息
     *
     * @param zfpxglJKcdjjl
     * @return
     */
    boolean insert(ZfpxglJKcdjjl zfpxglJKcdjjl);

    /**
     * 修改课程点击记录信息
     *
     * @param zfpxglJKcdjjl
     * @return
     */
    boolean updateById(ZfpxglJKcdjjl zfpxglJKcdjjl);

    /**
     * 根据ID删除课程点击记录信息
     *
     * @param id　课程点击记录ID
     * @return
     */
    boolean deleteById(String id);

    /**
     * 根据ID获取课程点击记录信息
     *
     * @param id
     * @return
     */
    ZfpxglJKcdjjl getById(String id);


    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @param zfpxglJKcdjjl
     * @return
     */
    Page<ZfpxglJKcdjjl> page(long current, long size, ZfpxglJKcdjjl zfpxglJKcdjjl);

    /**
     * 查询培训统计点击率折线图
     * @param nf
     * @return
     */
    List<String> queryDjlEcharts(String nf);

    /**
     * 查询最近三年集合
     * @return
     */
    List<String> queryYearList();

}

