package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.pxgl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.common.entity.FjVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.pxgl.entity.*;

import java.util.List;

/**
* @Description:    课件管理接口
* @Author:         lxr
* @CreateDate:     2020/6/2
* @Version:        1.0
*/
public interface KjXxService {
    /**
     * 分页查询
     *
     * @param current       当前页
     * @param size          每页显示条数
     * @param zfpxglJKjxxVO
     * @return
     */
    Page<ZfpxglJKjxxVO> page(long current, long size, ZfpxglJKjxxVO zfpxglJKjxxVO);

    /**
     * 课件审核-分页查询
     *
     * @param current       当前页
     * @param size          每页显示条数
     * @param zfpxglJKjxxVO
     * @return
     */
    Page<ZfpxglJKjxxVO> pageShengHe(long current, long size, ZfpxglJKjxxVO zfpxglJKjxxVO);

    /**
     * 新增课件信息
     *
     * @param zfpxglJKjxxVO
     * @return
     */
    boolean insert(ZfpxglJKjxxVO zfpxglJKjxxVO);

    /**
     * 新增课件操作记录
     *
     * @param zfpxglJKjczjlVO
     * @return
     */
    boolean insertCZ(ZfpxglJKjczjlVO zfpxglJKjczjlVO);

    /**
     * 修改课件信息信息
     *
     * @param zfpxglJKjxxVO
     * @return
     */
    boolean updateById(ZfpxglJKjxxVO zfpxglJKjxxVO,boolean flag);

    /**
     * 根据ID删除课件信息信息（可批量）
     *
     * @return
     */
    boolean deleteById(ZfpxglJKjxxVO zfpxglJKjxxVO);

    /**
     * 根据ID获取课件信息
     *
     * @param id
     * @return
     */
    ZfpxglJKjxxVO getById(String id);


    /**
     * 根据课件id查询所有附件
     *
     * @param kjxxId
     * @return
     */
    List<ZfpxglJKjfjxxVO> getKjfjById(String kjxxId);

    /**
     * 查询课件列表
     * @param zfryxxId 执法人员信息id
     * @param kcxxId 课程信息id
     * @return
     */
    public List<KjxxCustomVo> queryKjListByKcxxId(String zfryxxId,  String kcxxId,String fileType,String fileManagerUrl,String appcode,String fileManagerPreviewUrl);

    /**
     *  查询同类型的课件附件
     * @param kcxxId
     * @param zfryxxId
     * @param fileType
     * @return
     */
    public List<KjfjxxCustomVo> queryKjfjByType(String kcxxId,  String zfryxxId,  String fileType,String fileManagerUrl,String appcode,String xxzt,String fileManagerPreviewUrl);


    /**
     * 查询附件
     *
     * @param glid
     * @return
     */
    List<FjVO> getFjLj(String glid);

    /**
     * 查询未学习完的课件附件
     * @param kcxxId
     * @param zfryxxId
     * @param fileManagerUrl
     * @param fileManagerPreviewUrl
     * @param appcode
     * @return
     */
    List queryFileList(String kcxxId,String zfryxxId,String fileManagerUrl,String fileManagerPreviewUrl, String appcode);

    List queryFileListByApp(String kcxxId,String zfryxxId,String fileManagerVideoUrl);

    /**
     * 根据课件附件id查询附件
     *
     * @param kjfjId
     * @return
     */
    ZfpxglJKjfjxxVO getKjfjByFjId(String kjfjId);

    /**
     * 获取课程课件关联
     * @param kcxxId 课程信息id
     * @param kjxxId 课件信息id
     * @return
     */
    KcKjGlVo getByKcKj(String kcxxId,String kjxxId);
}
