package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.pxgl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.TreeDataVo;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.pxgl.entity.*;

import java.util.List;
import java.util.Map;

/**
* @Description: 课程信息接口
* @Author:         lxr
* @CreateDate:     2020/6/2
* @Version:        1.0
*/
public interface KcXxService {
    /**
     * 分页查询-培训课程
     *
     * @param current
     * @param size
     * @param zfryglJKcxxVO
     * @return
     */
    Page<ZfryglJKcxxVO> page(long current, long size, ZfryglJKcxxVO zfryglJKcxxVO);

    /**
     * 详情-培训课程
     *
     * @param zfryglJKcxxVO
     * @return
     */
    ZfryglJKcxxVO getById(ZfryglJKcxxVO zfryglJKcxxVO);

    /**
     * 新增&更新-课程库
     *
     * @param zfryglJKcxxVO
     * @return
     */
    boolean insert(ZfryglJKcxxVO zfryglJKcxxVO);

    /**
     * 分页查询-培训课程审核
     *
     * @param current
     * @param size
     * @param zfryglJKcxxVO
     * @return
     */
    Page<ZfryglJKcxxVO> pagesh(long current, long size, ZfryglJKcxxVO zfryglJKcxxVO);

    /**
     * 更新课程信息
     *
     * @param zfryglJKcxxVO
     * @return
     */
    boolean updateKckById(ZfryglJKcxxVO zfryglJKcxxVO,boolean flag);
    /**
     * 课程禁用/发布
     *
     * @param zfryglJKcxxVO
     * @return
     */
    boolean updateKcZt(ZfryglJKcxxVO zfryglJKcxxVO);

    /**
     * 记录课程操作信息
     *
     * @param zfpxglJKcczjlVO
     * @return
     */
    boolean insertCZ(ZfpxglJKcczjlVO zfpxglJKcczjlVO);

    /**
     * 查询课程分类树
     * @return
     */
    List<KcflVo> getTreekcfl();

    /**
     * 获取当前课程分类的下级
     *
     * @param kcfldm
     * @return
     */
    List<TreeDataVo> getTreekcflNext(String kcfldm, int level);

    /**
     * 获取关联的课件信息
     *
     * @param kcxxId
     * @return
     */
    List<ZfpxglJKjxxVO> getGlKjxxList(String kcxxId);

    /**
     * 获取关联的试题信息
     *
     * @param kcxxId
     * @return
     */
    List<ZfpxglJKccystVO> getGlStxxList(String kcxxId);

    /**
     * 新增课程测验试题(从题库选择)
     *
     * @param zfpxglJKccystVO
     * @return
     */
    boolean insertCyst(ZfpxglJKccystVO zfpxglJKccystVO);

    /**
     * 新增课程测验试题
     *
     * @param zfpxglJKccystVO
     * @return
     */
    boolean insertSt(ZfpxglJKccystVO zfpxglJKccystVO);

    /**
     * 修改课程测验试题
     *
     * @param zfpxglJKccystVO
     * @return
     */
    boolean updateSt(ZfpxglJKccystVO zfpxglJKccystVO);

    /**
     *新增时关闭弹框-物理删除
     *
     * @param kccystId
     * @return
     */
    boolean deleteStStXx(String kccystId);

    /**
     * 试题详情
     *
     * @param zfpxglJKccystVO
     * @return
     */
    ZfpxglJKccystVO searchKccyStxx(ZfpxglJKccystVO zfpxglJKccystVO);

    /**
     * 删除课程
     * @param zfryglJKcxxVO
     * @return
     */
    boolean deleteById(ZfryglJKcxxVO zfryglJKcxxVO);

    /**
     * 前端查询课程列表
     * @param page
     * @param mp
     * @return
     */
    Page<Map<String,Object>> pageQd(Page<Map<String,Object>> page , Map<String,Object> mp);

    /**
     * 根据id查询课程信息
     * @param mp
     * @return
     */
    Map<String,Object> queryKcxxById(Map<String,Object> mp);

    /**
     * 查询课程考试试题信息列表
     * @param kcxxId
     * @return
     */
    List<Map<String,Object>> queryStListByKcxxId(String kcxxId);

    /**
     * app查询课程考试试题ID
     * @param kcxxId
     * @return
     */
    List<AppKcxxKsstVo> queryStListByApp(String kcxxId);
    /**
     * app查询课程考试试题信息
     * @param kcxxId
     * @return
     */
    List<Map<String,String>> queryStxxListByApp(String kcxxId,String stId);

    /**
     * 查询echart试图参数，课程分类饼状图
     * @param digit 课程分类位数
     * @return
     */
    List<Map<String,Object>> queryEchartsKcflList(Integer digit);

    /**
     * 查询已发布课程总数
     * @return
     */
    Integer queryKcNum();


}
