package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.pxgl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.pxgl.entity.PxJhNddbzVo;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.pxgl.entity.ZfpxglJPxjhVO;

/**
 * @Description: 培训计划接口类
 * @Author: lxr
 * @CreateDate: 2020/6/2
 * @Version: 1.0
 */
public interface JhXxService {
    /**
     * 分页查询-培训计划
     *
     * @param current
     * @param size
     * @param zfpxglJPxjhVO
     * @return
     */
    Page<ZfpxglJPxjhVO> page(long current, long size, ZfpxglJPxjhVO zfpxglJPxjhVO);

    /**
     * 分页查询-达标值
     *
     * @param current
     * @param size
     * @return
     */
    Page<PxJhNddbzVo> dbzpage(long current, long size);

    /**
     * 新增培训计划
     *
     * @param zfpxglJPxjhVO
     * @param fjDetail
     * @return
     */
    boolean insert(ZfpxglJPxjhVO zfpxglJPxjhVO, String fjDetail);

    /**
     * 新增达标设置
     *
     * @param pxJhNddbzVo
     * @return
     */
    boolean insertDbz(PxJhNddbzVo pxJhNddbzVo);

    /**
     * 更新培训计划
     *
     * @param zfpxglJPxjhVO
     * @param fjDetail
     * @return
     */
    boolean updateById(ZfpxglJPxjhVO zfpxglJPxjhVO, String fjDetail);

    /**
     * 更新达标设置
     *
     * @param pxJhNddbzVo
     * @return
     */
    boolean updateDbzById(PxJhNddbzVo pxJhNddbzVo);

    /**
     * 删除培训计划
     *
     * @param zfpxglJPxjhVO
     * @return
     */
    boolean delete(ZfpxglJPxjhVO zfpxglJPxjhVO);

    /**
     * 获取培训计划详情
     *
     * @param zfpxglJPxjhVO
     * @return
     */
    ZfpxglJPxjhVO getById(ZfpxglJPxjhVO zfpxglJPxjhVO);

    /**
     * 查询某年度线上学习的培训计划
     *
     * @param nd
     * @return
     */
    ZfpxglJPxjhVO queryZxxxByNd(String nd);

    /**
     * 查询当期年度是否已经存在线上学习计划
     *
     * @return
     */
    boolean xsxxsfcz(String year, String pxjhId);

    /**
     * 查询当期年度达标设置情况
     *
     * @return
     */
    PxJhNddbzVo getDbzszDetail(String nd);
}
