package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.pxgl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * <p>
 * 课程信息
 * </p>
 *
 * @author lixianrui
 * @since 2020-05-11
 */
@Data
@TableName("ZFRYGL_J_KCXX")
public class ZfryglJKcxxVO extends BaseEntity<String> {
    private static final long serialVersionUID = 1L;

    /**
     * 课程信息的唯一标识。
     */
    @TableId
    private String kcxxId;

    /**
     * 课程分类代码
     */
    private String kcfldm;
    /**
     * 课程分类代码
     */
    @TableField(exist = false)
    private String kcflmc;
    /**
     * 课程分类代码
     */
    @TableField(exist = false)
    private String[] kcfldmarr;
    /**
     * 学习类型
     */
    @TableField(exist = false)
    private String xxlx;

    /**
     * 组织机构ID
     */
    private String zzjgid;

    /**
     * 课程名称
     */
    private String kcmc;

    /**
     * 授课人
     */
    private String skr;

    /**
     * 课程简介
     */
    private String kcjj;

    /**
     * 学时（单位：小时）
     */
    private BigDecimal xs;

    /**
     * 学分
     */
    private BigDecimal xf;

    /**
     * 搜索关键字
     */
    private String gjz;

    /**
     * 课程缩略图
     */
    private String kcslt;

    /**
     * 奖励学分
     */
    private BigDecimal jlxf;

    /**
     * 状态：0 已保存 1 待审核 2 审核通过 3 审核不通过 4 已发布9 已关闭
     */
    private String kczt;

    @TableField(exist = false)
    private String kcztmc;
    /**
     * 发布日期
     */
    private Date fbrq;

    /**
     * 阅读次数
     */
    private Long ydcs;

    /**
     * 点赞数
     */
    private Long dzs;

    /**
     * 评价星级
     */
    private BigDecimal pjxj;
    /**
     * 审核不通过的意见
     */
    @TableField(exist = false)
    private String yj;
    /**
     * 需要删除的课程id
     */
    @TableField(exist = false)
    private String[] deleteKcxxIdArr;

    /**
     * 需要删除的照片附件
     */
    @TableField(exist = false)
    private String[] deletefj;
    /**
     * 需要删除的试题id
     */
    @TableField(exist = false)
    private String[] deleteStId;
    /**
     * 照片附件详情
     */
    @TableField(exist = false)
    private String zpfjDetail;
    /**
     * 存储材料路径
     */
    @TableField(exist = false)
    private List<String> bcljArr = new ArrayList();
    /**
     * 存储材料名称
     */
    @TableField(exist = false)
    private List<String> clmcArr = new ArrayList();
    /**
     * 存储附件id
     */
    @TableField(exist = false)
    private List<String> fjidArr = new ArrayList();
    /**
     * 存储附件类型
     */
    @TableField(exist = false)
    private List<String> lxArr = new ArrayList();
    /**
     * 选择的课件id数组
     */
    @TableField(exist = false)
    private String[] kjxxidArr;

    @TableField(exist = false)
    private String kjxxid;
    /**
     * 试题id（未编辑的可以直接关联考试试题的）
     */
    @TableField(exist = false)
    private String[] tkxxidArr;
    /**
     * 修改分值的试题id和fz
     */
    @TableField(exist = false)
    private String modifyFz;
    /**
     * 页面操作类型 根据cztype判断是新增或者是编辑（仅靠有无id无法判断）xinzeng    bianji
     */
    @TableField(exist = false)
    private String cztype;
    /**
     * 课程上传者id(课程上传奖励用)
     */
    @TableField(exist = false)
    private String createrId;

    @Override
    public String getId() {
        return kcxxId;
    }

    @Override
    public void setId(String id) {
        this.kcxxId = id;
    }
}
