package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.pxgl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 执法人员课件附件的下载信息
 * </p>
 *
 * @author LSH
 * @since 2020-07-03
 */
@Data
@TableName("ZFPXGL_J_ZFRY_KJFJ_GL")
public class ZfryKjfjGlVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 执法人员基本信息的唯一标识。
     */
    @TableId
    private String zfryxxId;

    /**
     * 课件附件信息的唯一标识
     */
    private String kjfjxxId;

    /**
     * 课件信息的唯一标识
     */
    private String kjxxId;

    /**
     * 课件名称
     */
    private String kjmc;

    /**
     * 附件名称
     */
    private String fjmc;

    /**
     * 附件大小
     */
    private String fjdx;

    /**
     * 顺序号
     */
    private Integer sxh;

    /**
     * 下载时间
     */
    private Date xzsj;

    /**
     * 下载状态 0 下载中 1 已下载
     */
    private String xzzt;

    /**
     * 下载本地位置
     */
    private String xzbdwz;

    /**
     * 创建人
     */
    private String creater;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改人
     */
    private String updater;

    /**
     * 修改时间
     */
    private Date updateTime;

    /**
     * 学习位置
     */
    private String xxwz;
    /**
     * 学习状态 0未学习 1已学习 2学习中
     */
    private String xxzt;

    /**
     * 课程信息id
     */
    private String kcxxId;

    /**
     * 学分
     */
    @TableField(exist = false)
    private String xf;

    /**
     * 学时
     */
    @TableField(exist = false)
    private String xs;
    /**
     * 总时长
     */
    @TableField(exist = false)
    private String zsc;
    /**
     * zzjgid
     */
    @TableField(exist = false)
    private String zzjgid;
    /**
     * 课件类型代码（APP-我的下载用）
     */
    @TableField(exist = false)
    private String kjlxdm;
    /**
     * 某个课件类型数量（APP-我的下载用）
     */
    @TableField(exist = false)
    private String kjnum;
    /**
     * 课件附件url（APP-我的下载用）
     */
    @TableField(exist = false)
    private String kjfjurl;
    /**
     * 课程名称
     */
    @TableField(exist = false)
    private String kcmc;


    @Override
    public String getId() {
        return zfryxxId;
    }

    @Override
    public void setId(String id) {
        this.zfryxxId = id;
    }


}
