package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.pxgl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.math.BigDecimal;


/**
 * <p>
 * 执法人员课程的学习状态、点赞状态
 * </p>
 *
 * @author LSH
 * @since 2020-07-03
 */
@Data
@TableName("ZFPXGL_J_ZFRY_KC_GL")
public class ZfryKcGlVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 执法人员基本信息的唯一标识。
     */
    @TableId
    private String zfryxxId;

    /**
     * 课程信息的唯一标识。
     */
    private String kcxxId;

    /**
     * 学习状态，0 未学习 1 已学习
     */
    private String xxzt;

    /**
     * 点赞状态 0 未点赞 1 已点赞
     */
    private String dzzt;

    /**
     * 评分状态 0 未点评 1 已点评
     */
    private String pfzt;

    /**
     * 评分星级
     */
    private String pfxj;
    /**
     * 所获学分
     */
    private BigDecimal shxf;
    /**
     * 学时
     */
    private BigDecimal xs;
    /**
     * 测验成绩
     */
    private String cycj;
    /**
     * 测验结果
     */
    private String cyjg;

    /**
     * 学习进度
     */
    @TableField(exist = false)
    private String learnRate;

    /**
     * 已学时长
     */
    @TableField(exist = false)
    private String yxsc;

    /**
     * 总学时
     */
    @TableField(exist = false)
    private String zsc;

    /**
     * 姓名
     */
    @TableField(exist = false)
    private String xm;

    /**
     * 执法证号
     */
    @TableField(exist = false)
    private String zfzh;
    /**
     * 所属单位
     */
    @TableField(exist = false)
    private String ssdw;

    /**
     * 查询范围
     */
    @TableField(exist = false)
    private String cxfw;

    /**
     * 过关试题数量
     */
    @TableField(exist = false)
    private String ggstsl;


    @Override
    public String getId() {
        return zfryxxId;
    }

    @Override
    public void setId(String id) {
        this.zfryxxId = id;
    }


}
