package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.pxgl.entity;


import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 学分申报信息
 * </p>
 *
 * @author jqq
 * @since 2020-05-12
 */
@Data
@TableName("ZFPXGL_J_XFSBXX")
public class ZfpxglJXfsbxxVo extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 学分申报信息ID
     * 学分申报信息的唯一标识
     */
    @TableId
    private String xfsbxxId;

    /**
     * 执法人员信息ID
     * 执法人员基本信息的唯一标识
     */
    private String zfryxxId;

    /**
     * 执法人员姓名
     */
    private String xm;

    /**
     * 执法证号
     */
    private String zfzh;

    /**
     * 组织机构ID
     */
    private String zzjgid;

    /**
     * 所属机构
     */
    private String ssjg;

    /**
     * 培训类型代码
     */
    private String pxlxdm;

    /**
     * 培训名称
     */
    private String pxmc;

    /**
     * 培训描述
     */
    private String pxms;

    /**
     * 开始时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date kssj;

    /**
     * 结束时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date jssj;

    /**
     * 培训证书名称
     */
    private String pxzsmc;

    /**
     * 证书编号
     */
    private String zsbh;

    /**
     * 培训机构名称
     */
    private String pxjgmc;

    /**
     * 总学时
     */
    private BigDecimal zxs;

    /**
     * 总学分
     */
    private BigDecimal zxf;

    /**
     * 总课时
     */
    private BigDecimal zks;

    /**
     * 申报日期
     */
    private Date sbrq;

    /**
     * 审核日期
     */
    private Date shrq;

    /**
     * 状态：0 未申报 1 待审核 2 审核通过 3 审核不通过
     */
    private String sbzt;

    /**
     * 删除状态：00未删除01已删除
     */
    private String deleteFlag;

    /**
     * 备注
     */
    @TableField(exist = false)
    private String bz;
    /**
     * 操作人
     */
    @TableField(exist = false)
    private String czr;
    /**
     * 培训类型
     */
    @TableField(exist = false)
    private String pxlx;

    @Override
    public String getId() {
        return xfsbxxId;
    }

    @Override
    public void setId(String id) {
        this.xfsbxxId = id;
    }


}
