package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.pxgl.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 学分记录
 * </p>
 *
 * @author pt
 * @since 2020-05-07
 */
@Data
@TableName("ZFPXGL_J_XFJL")
public class ZfpxglJXfjl extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 学分记录的唯一标识。
     */
    @TableId
    private String xfjlId;

    /**
     * 执法人员基本信息的唯一标识。
     */
    private String zfryxxId;

    /**
     * 年度学分记录的唯一标识。
     */
    private String ndxfjlId;

    /**
     * 学习内容（根据来源显示，课程名称/培训名称/考试名称）
     */
    private String xxnr;

    /**
     * 存对应学习内容的ID（如课程ID，培训ID，考试ID等）
     */
    private String xxnrid;

    /**
     * 获取途径：1 在线学习，2 线下培训，3 外部培训，4 内部考试
     */
    private String hqtj;

    /**
     * 获取时间
     */
    private Date hqsj;

    /**
     * 学分
     */
    private BigDecimal xf;

    /**
     * 学时
     */
    private BigDecimal xs;


    @Override
    public String getId() {
        return xfjlId;
    }

    @Override
    public void setId(String id) {
        this.xfjlId = id;
    }


}
