package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.pxgl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 培训批次信息
 * </p>
 *
 * @author lixianrui
 * @since 2020-05-18
 */
@Data
@TableName("ZFPXGL_J_PXPCXX")
public class ZfpxglJPxpcXxVO extends BaseEntity<String> {
    private static final long serialVersionUID = 1L;

    /**
     * 培训批次信息的唯一标识
     */
    @TableId
    private String pxpcxxId;

    /**
     * 培训类型代码
     */
    private String pxlxdm;

    /**
     * 培训计划的唯一标识
     */
    private String pxjhId;

    /**
     * 培训批次名称（计划名+批次）
     */
    private String mc;

    /**
     * 第几批次
     */
    private String pc;

    /**
     * 开始时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date kssj;
    /**
     * 开始时间
     */
    @TableField(exist = false)
    private String kssjStr;

    /**
     * 结束时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date jssj;
    /**
     * 结束时间
     */
    @TableField(exist = false)
    private String jssjStr;

    /**
     * 培训证书名称
     */
    private String pxzsmc;

    /**
     * 是否考试：0 否 1 是
     */
    private String sfks;

    /**
     * 简介
     */
    private String jj;

    /**
     * 培训机构名称
     */
    private String pxjgmc;

    /**
     * 总课时
     */
    private BigDecimal zks;

    /**
     * 总学分
     */
    private BigDecimal zxf;

    /**
     * 状态：0 暂存，1 提交
     */
    private String zt;
    /**
     * 查询-培训开始时间区间数组
     */
    @TableField(exist = false)
    private String[] kssjArr;
    /**
     * 查询-培训结束时间区间数组
     */
    @TableField(exist = false)
    private String[] jssjArr;

    /**
     * 标记 为1的话啊说明是考试管理这边调用
     */
    @TableField(exist = false)
    private String flag;
    /**
     * 线下培训课程
     */
    @TableField(exist = false)
    private String pxkc;
    /**
     * 培训批次人员关联
     */
    @TableField(exist = false)
    private String cxry;
    /**
     * 线下培训课程ids
     */
    @TableField(exist = false)
    private String xxpxkcIds;
    /**
     * 执法人员信息ids
     */
    @TableField(exist = false)
    private String zfryxxIds;
    /**
     * 年度
     */
    @TableField(exist = false)
    private String nd;
    /**
     * 所属培训计划
     */
    @TableField(exist = false)
    private String jhmc;
    /**
     * 所属机构
     */
    @TableField(exist = false)
    private String ssjg;
    /**
     * 组织机构id
     */
    @TableField(exist = false)
    private String zzjgId;
    /**
     * 空为全部 01本单位 02下级单位
     */
    @TableField(exist = false)
    private String cxfw;
    /**
     * 机构名称
     */
    @TableField(exist = false)
    private String orgName;
    /**
     * 培训类型名称
     */
    @TableField(exist = false)
    private String pxlxmc;
    /**
     * 培训类型名称
     */
    @TableField(exist = false)
    private String pxlx;
    /**
     * 附件详情
     */
    @TableField(exist = false)
    private String fjDetail;
    /**
     * 删除的附件信息
     */
    @TableField(exist = false)
    private String[] deletefj;
    /**
     * 存储材料路径
     */
    @TableField(exist = false)
    private List<String> bcljArr = new ArrayList();
    /**
     * 存储材料名称
     */
    @TableField(exist = false)
    private List<String> clmcArr = new ArrayList();
    /**
     * 存储附件id
     */
    @TableField(exist = false)
    private List<String> fjidArr = new ArrayList();
    /**
     * 存储附件类型
     */
    @TableField(exist = false)
    private List<String> lxArr = new ArrayList();
    /**
     * 文件服务器key
     */
    @TableField(exist = false)
    private List<String> keyIdArr = new ArrayList();

    /**
     * 监督评议-培训人次数
     */
    @TableField(exist = false)
    private Integer pxrs;

    /**
     * 监督评议-培训开始时间
     */
    @TableField(exist = false)
    private String startPxTime;
    /**
     * 监督评议-培训结束时间
     */
    @TableField(exist = false)
    private String endPxTime;

    @Override
    public String getId() {
        return pxpcxxId;
    }

    @Override
    public void setId(String id) {
        this.pxpcxxId = id;
    }
}
