package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.pxgl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 培训计划
 * </p>
 *
 * @author lixianrui
 * @since 2020-05-09
 */
@Data
@TableName("ZFPXGL_J_PXJH")
public class ZfpxglJPxjhVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 培训计划的唯一标识
     */
    @TableId
    private String pxjhId;

    /**
     * 组织机构ID
     */
    private String zzjgid;
    /**
     * 组织机构名称
     */
    @TableField(exist = false)
    private String zzjgmc;
    /**
     * 培训类型代码
     */
    private String pxlxdm;

    /**
     * 年度
     */
    private String nd;

    /**
     * 计划名称
     */
    private String jhmc;

    /**
     * 计划描述
     */
    private String jhms;

    /**
     * 计划批次
     */
    private String jhpc;

    /**
     * 计划状态：0 未完成 1 已完成
     */
    private String jhzt;

    /**
     * 附件，多个以逗号隔开
     */
    private String fj;

    /**
     * 年度学分达标值
     */
    @TableField(exist = false)
    private BigDecimal ndxfdbz;

    /**
     * 年度学时达标值
     */
    @TableField(exist = false)
    private BigDecimal ndxsdbz;

    /**
     * 培训信息ID数组
     */
    @TableField(exist = false)
    private String[] zfpxJhIdArr;
    /**
     * 需要删除的照片附件
     */
    @TableField(exist = false)
    private String[] deletefj;
    /**
     * 存储材料路径
     */
    @TableField(exist = false)
    private List bcljArr = new ArrayList();
    /**
     * 存储材料名称
     */
    @TableField(exist = false)
    private List clmcArr = new ArrayList();
    /**
     * 存储附件id
     */
    @TableField(exist = false)
    private List fjidArr = new ArrayList();
    /**
     * 存储附件类型
     */
    @TableField(exist = false)
    private List lxArr = new ArrayList();
    /**
     * 年度最大批次
     */
    @TableField(exist = false)
    private Integer pc;
    /**
     * 培训类型名称
     */
    @TableField(exist = false)
    private String pxlx;
    /**
     * 培训批次数
     */
    @TableField(exist = false)
    private Integer pxcs;

    @Override
    public String getId() {
        return pxjhId;
    }

    @Override
    public void setId(String id) {
        this.pxjhId = id;
    }
}
