package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.pxgl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 课件信息
 * </p>
 *
 * @author lixianrui
 * @since 2020-04-30
 */
@Data
@TableName("ZFPXGL_J_KJXX")
public class ZfpxglJKjxxVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 课件信息的唯一标识
     */
    @TableId
    private String kjxxId;

    /**
     * 课件类型代码
     */
    private String kjlxdm;

    @TableField(exist = false)
    private String kjlxmc;

    /**
     * 课件简介
     */
    private String kjjj;

    /**
     * 课件名称
     */
    private String kjmc;

    /**
     * 0 已保存 1 待审核 2 审核通过 3 审核不通过 4 已发布 5 待上报 9 禁用
     */
    private String kjzt;

    /**
     * 课件状态：0 已保存 1 已发布 9 禁用
     */
    @TableField(exist = false)
    private String kjztmc;

    /**
     * 阅读方式：0 仅阅读 1 阅读及下载
     */
    private String ydfs;

    @TableField(exist = false)
    private String ydfsmc;
    /**
     * 不通过意见
     */
    @TableField(exist = false)
    private String yj;
    /**
     * 课件大小
     */
    private String kjdx;

    /**
     * 法律法规类别：01 法律
     * 02 行政法规
     * 03 地方性法规
     * 04 部门规章
     * 05 政府规章
     * 06 其他规范性文件
     */
    private String flfglbdm;

    @TableField(exist = false)
    private String flfglbmc;

    /**
     * 组织机构唯一标识
     */
    private String zzjgid;

    /**
     * 学时
     */
    private Double xs;

    /**
     * 学分
     */
    private Double xf;

    /**
     * 发布日期
     */
    private Date fbrq;

    /**
     * 禁用日期
     */
    private Date jyrq;

    /**
     * 批量删除的课件id数组
     */
    @TableField(exist = false)
    private String[] kjxxIdArr;
    /**
     * 删除的附件id数组
     */
    @TableField(exist = false)
    private String[] deletefjId;
    /**
     * 课件附件
     */
    @TableField(exist = false)
    private String kjfjDetail;
    /**
     * 存储材料路径
     */
    @TableField(exist = false)
    private List<String> bcljArr = new ArrayList();
    /**
     * 存储材料名称
     */
    @TableField(exist = false)
    private List<String> clmcArr = new ArrayList();
    /**
     * 存储附件id
     */
    @TableField(exist = false)
    private List<String> fjidArr = new ArrayList();
    /**
     * 存储附件文件服务器id
     */
    @TableField(exist = false)
    private List<String> keyIdArr = new ArrayList();
    /**
     * 存储附件文件大小
     */
    @TableField(exist = false)
    private List<String> fjdxArr = new ArrayList();
    /**
     * 存储附件类型
     */
    @TableField(exist = false)
    private List<String> lxArr = new ArrayList();
    /**
     * 时长类型
     */
    @TableField(exist = false)
    private List<String> scArr = new ArrayList();
    /**
     * 学分类型
     */
    @TableField(exist = false)
    private List<String> xfArr = new ArrayList();

    @Override
    public String getId() {
        return kjxxId;
    }

    @Override
    public void setId(String id) {
        this.kjxxId = id;
    }


}
