package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.pxgl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.List;

/**
 * <p>
 * 课程测验试题
 * </p>
 *
 * @author lixianrui
 * @since 2020-05-19
 */
@Data
@TableName("ZFPXGL_J_KCCYST")
public class ZfpxglJKccystVO extends BaseEntity<String> {
    private static final long serialVersionUID = 1L;

    /**
     * 课程测验试题的唯一标识
     */
    @TableId
    private String kccystId;

    /**
     * 课程信息的唯一标识。
     */
    private String kcxxId;

    /**
     * 试题的唯一标识
     */
    private String stId;

    /**
     * 试题题型代码
     */
    private String sttxdm;
    /**
     * 试题题型代码
     */
    @TableField(exist = false)
    private String sttxdmmc;

    /**
     * 编号
     */
    private String bh;

    /**
     * 内容
     */
    private String nr;

    /**
     * 判断题答案：1 对 2 错
     */
    private String da;

    /**
     * 分值
     */
    private Integer fz;
    /**
     * 试题选项集合
     */
    @TableField(exist = false)
    private List<ZfpxglJCystxxVO> stxxlist;
    /**
     * 提交的试题信息{"stxx":[{"stxxId":"0001","xxdm":"A","xxmc":"选项名称A","sfzqda":"0"},{"stxxId":"0001","xxdm":"B","xxmc":"选项名称B","sfzqda":"1"}],"st":[{"zfmldm":"001","kstkId":"id","sttxdm":"02","nr":"内容","da":"答案填ABCD"}]}
     */
    @TableField(exist = false)
    private String addStInfo;

    /**
     * 试题选项ID集合
     */
    @TableField(exist = false)
    private  String[] deleteStxxIdList;
    /**
     * 执法人员信息id
     */
    @TableField(exist = false)
    private  String zfryxxId;
    /**
     * 页面操作类型 根据type判断是新增或者是编辑（仅靠有无id无法判断）
     */
//    @TableField(exist = false)
//    private  String type;
    @Override
    public String getId() {
        return kccystId;
    }

    @Override
    public void setId(String id) {
        this.kccystId = id;
    }
}
