package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.pxgl.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 培训批次里执法人员的培训结果信息
 * 添加字段：所获学分，所获学时，培训结果，培训证书编号，培训证书名称，培训类型
 * </p>
 *
 * @author jqq
 * @since 2020-05-14
 */
@Data
@TableName("ZFPXGL_J_PXPC_RY_GL")
public class PxpcRyGlVo extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 培训批次信息的唯一标识
     */
    private String pxpcxxId;

    /**
     * 执法人员基本信息的唯一标识。
     */
    private String zfryxxId;

    /**
     * 培训类型代码
     */
    private String pxlxdm;

    /**
     * 执法人员的姓名。
     */
    private String xm;

    /**
     * 执法人员人员的身份证号码。
     */
    private String sfzjhm;

    /**
     * 执法证号
     */
    private String zfzh;

    /**
     * 所属机构名称
     */
    private String ssjg;

    /**
     * 人员的性别代码。
     */
    private String xbdm;

    /**
     * 执法人员执法门类的代码。
     */
    private String zfmldm;

    /**
     * 所获学分
     */
    private BigDecimal shxf;

    /**
     * 所获学时
     */
    private BigDecimal shxs;

    /**
     * 证书编号
     */
    private String zsbh;

    /**
     * 证书名称
     */
    private String zsmc;

    /**
     * 培训结果：0 不合格 1 合格
     */
    private String pxjg;

    /**
     * 创建人
     */
    private String creater;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改人
     */
    private String updater;

    /**
     * 修改时间
     */
    private Date updateTime;

    /**
     * 人员审批状态
     */
    private String ryspztdm;

    @Override
    public String getId() {
        return pxpcxxId;
    }

    @Override
    public void setId(String id) {
        this.pxpcxxId = id;
    }


}
