package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.pxgl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.math.BigDecimal;

/**
 * <p>
 * 年度学分记录
 * </p>
 *
 * @author pt
 * @since 2020-05-06
 */
@Data
@TableName("ZFPXGL_J_NDXFJL")
public class PxglJNdxfjl extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 年度学分记录的唯一标识。
     */
    @TableId
    private String ndxfjlId;

    /**
     * 执法人员基本信息的唯一标识。
     */
    private String zfryxxId;

    /**
     * 年度
     */
    private String nd;

    /**
     * 总学分
     */
    private BigDecimal zxf;

    /**
     * 总学时
     */
    private BigDecimal zxs;

    /**
     * 学分是否达标：0 否 1 是
     */
    private String sfdb;

    /**
     * 总学习时长
     */
    private BigDecimal zxxsc;

    /**
     * 学时是否达标：0 否 1 是
     */
    private String xssfdb;

    /**
     * 人员所在机构
     */
    @TableField(exist = false)
    private String zzjgid;

    /**
     * 所在机构
     */
    @TableField(exist = false)
    private String ssjg;

    /**
     * 人员的性别代码。
     */
    @TableField(exist = false)
    private String xbdm;

    /**
     * 执法人员的姓名。
     */
    @TableField(exist = false)
    private String xm;

    /**
     * 执法人员人员的身份证号码。
     */
    @TableField(exist = false)
    private String sfzjhm;

    /**
     * 执法证号
     */
    @TableField(exist = false)
    private String zfzh;

    /**
     * 查询范围
     */
    @TableField(exist = false)
    private String cxfw;
    /**
     * 学分是否达标文字
     */
    @TableField(exist = false)
    private  String sfdbWZ;
    /**
     * 学时是否达标：0 否 1 是
     */
    @TableField(exist = false)
    private String xssfdbWz;
    /**
     * 最小学分
     */
    @TableField(exist = false)
    private String xffwMin;
    /**
     * 最大学分
     */
    @TableField(exist = false)
    private String xffwMax;
    /**
     * 最小学时
     */
    @TableField(exist = false)
    private String xsfwMin;
    /**
     * 最大学时
     */
    @TableField(exist = false)
    private String xsfwMax;
    /**
     * 年龄
     */
    @TableField(exist = false)
    private String age;
    @Override
    public String getId() {
        return ndxfjlId;
    }

    @Override
    public void setId(String id) {
        this.ndxfjlId = id;
    }


}
