package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.ksgl.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.TreeDataVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.ksgl.entity.StJcTxVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.ksgl.entity.StVO;

import java.util.List;

/**
 * <p>
 * 试题 服务类
 * </p>
 *
 * @author pt
 * @since 2020-04-13
 */
public interface ZfksglJStService {

    /**
     * 新增试题信息
     *
     * @param zfksglJSt
     * @return
     */
    boolean insert(StVO zfksglJSt);

    /**
     * 修改试题信息
     *
     * @param zfksglJSt 试题信息
     * @param curUser
     * @return
     */
    boolean updateSt(StVO zfksglJSt, SysUser curUser);

    /**
     * 根据ID删除试题信息
     *
     * @param id 　试题ID
     * @return
     */
    boolean deleteById(String id);

    /**
     * 根据ID批量删除试题信息
     *
     * @param zfksglJSt
     * @return
     */
    boolean deleteByIds(StVO zfksglJSt);

    /**
     * 根据ID批量公开练习
     * @param stIds
     * @param flag
     * @return
     */
    int sfplgklx(String[] stIds, boolean flag,SysUser user);

    /**
     * 根据ID获取试题信息
     *
     * @param id
     * @return
     */
    StVO getById(String id);


    /**
     * 分页查询
     *
     * @param current   当前页
     * @param size      每页显示条数
     * @param zfksglJSt
     * @return
     */
    Page<StVO> page(long current, long size, StVO zfksglJSt);

    // 获取考试题库集合
    List<TreeDataVo> getkstk(SysUser sysUser);

    //更新试题状态
    boolean updateksstzt(StVO zfksglJSt);

    /**
     * 查询试题详细信息
     *
     * @param stVO
     * @return
     */
    StVO searchstxx(StVO stVO);

    /**
     * 查询试题的纠错信息列表
     *
     * @param stId
     * @return
     */
    List<StJcTxVO> selectJcTxInfo(String stId);

    /**
     * 提交纠错提醒
     *
     * @param stJcTxVO
     * @return
     */
    boolean handleJcTx(StJcTxVO stJcTxVO);

    /***
     * 获取试题纠错信息
     * @param stjctxId
     * @return
     */
    StJcTxVO viewJcTx(String stjctxId);
}

