package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.ksgl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.ComboboxVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.ksgl.entity.MbJdVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.ksgl.entity.SjMbVO;

import java.util.List;


/**
 * <p>
 * 试卷模板 服务类
 * </p>
 *
 * @author pt
 * @since 2020-04-01
 */
public interface ZfksglJSjmbService {
    /**
     * 新增试卷模板信息
     *
     * @param sjMbVO
     * @return
     */
    boolean insert(SjMbVO sjMbVO);

    /**
     * 修改试卷模板信息
     *
     * @param sjMbVO
     * @return
     */
    boolean updateSjMb(SjMbVO sjMbVO);

    /**
     * 根据ID删除试卷模板信息
     *
     * @param id　试卷模板ID
     * @return
     */
    boolean deleteById(String id);

    /**
     * 批量删除试卷模板信息
     *
     * @param sjMbVO　
     * @return
     */
    boolean deleteSjMb(SjMbVO sjMbVO, MbJdVO mbJdVO);

    /**
     * 启动试卷模板信息
     *
     * @param sjmb
     * @return
     */
    boolean updatesjmbzt(SjMbVO sjmb);


    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @param sjMbVO
     * @return
     */
    Page<SjMbVO> page(long current, long size, SjMbVO sjMbVO);

    /**
     * 根据所选执法门类查询试题题型
     * @param sjMbVO
     * @return
     */
    List<ComboboxVo> queryTxByZfMl(SjMbVO sjMbVO);

    /**
     * 查询试卷模板的信息
     * @param sjmbId
     * @param bbh
     * @return
     */
    SjMbVO viewSjMbInfo(String sjmbId,String bbh,SysUser sysUser);
    /**
     * 查询执法门类下面题型的数量
     * @param zfmldmArr
     * @return
     */
    List<SjMbVO> checkStSl(String[] zfmldmArr, String sttxdm, SysUser sysUser);
}
