package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.ksgl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.common.entity.SjUtilVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.common.entity.TkTreeVo;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.ksgl.entity.*;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.zfks.entity.ZfksSjVo;

import java.util.List;

/**
 * <p>
 * 试卷 服务类
 * </p>
 *
 * @author pt
 * @since 2020-04-01
 */

public interface ZfksglJSjService {
    /**
     * 新增试卷信息
     *
     * @param sjVO
     * @return
     */
    boolean insert(SjVO sjVO);

    /**
     * 修改试卷信息
     *
     * @param sjVO
     * @return
     */
    boolean updateById(SjVO sjVO);

    /**
     * 根据ID删除试卷信息
     *
     * @param id 　试卷ID
     * @return
     */
    boolean deleteById(String id, SysUser sysUser);

    /**
     * 根据ID批量删除试卷信息
     *
     * @param sjIds 　试卷ID
     * @return
     */
    boolean deleteByIds(String[] sjIds);

    /**
     * 修改试卷状态
     *
     * @param sjVO
     * @param sjczjl
     * @return
     */
    boolean updatesjzt(SjVO sjVO, SjCzJlVO sjczjl);

    /**
     * 试卷记录表插入数据
     *
     * @param sjczjl
     * @return
     */
    boolean insertsjczjl(SjCzJlVO sjczjl);

    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size    每页显示条数
     * @param sjVO
     * @return
     */
    Page<SjVO> page(long current, long size, SjVO sjVO);

    /**
     * 查询试卷模板名称下拉框
     *
     * @param name 模板名称
     * @return
     */
    List<SjMbComBoxVO> querySjMbNameComBox(String name, SysUser sysUser);

    /**
     * 查询 新增试卷时的题库下拉框
     *
     * @param mbVO
     * @return
     */
    List<TkTreeVo> queryTkXlk(SjMbVO mbVO, SysUser sysUser);

    /**
     * 试卷模板的题型数量
     *
     * @param mbVO
     * @return
     */
    StVO queryMbTxSl(SjMbVO mbVO);

    /**
     * 校验所选题库中试题题型的数量
     *
     * @param stVo
     * @return
     */
    StVO checkTxSl(StVO stVo);

    /**
     * 手动抽取试题
     *
     * @param current
     * @param size
     * @param stVo
     * @return
     */
    Page<StVO> querySdCqSt(long current, long size, StVO stVo);

    /**
     * 根据试卷模板ID和版本号查询模板节段信息
     *
     * @param mbJdVO
     * @return
     */
    List<MbJdVO> queryMbJd(MbJdVO mbJdVO);

    /**
     * 随机替换试题
     *
     * @param stVO
     * @return
     */
    List<StVO> querySjCqSt(StVO stVO);

    /**
     * 随机抽取试题
     *
     * @param stVO
     * @return
     */
    List<StVO> queryRandomSt(StVO stVO);

    /**
     * 模糊查询试手动抽取试题的内容
     *
     * @param stVO
     * @return
     */
    List<SjMbComBoxVO> querySdCqNrMh(StVO stVO);

    /**
     * 获取试卷信息
     *
     * @param sjVO
     * @return
     */
    SjVO querySjInfo(SjVO sjVO);


    /**
     * 预览试卷
     *
     * @return
     */
    List<SjUtilVO> queryPreviewSJ(SjStGlVO sjStGlVO);

    /**
     * 查询试卷试题的信息
     *
     * @param sjStGlVO
     * @return
     */
    List<SjStGlVO> querySjStInfo(SjStGlVO sjStGlVO);

    /**
     * 更换组卷方式清空试题及试题选项
     *
     * @param sjVO
     * @return
     */
    boolean updateSjSt(SjVO sjVO, SysUser sysUser);

    /**
     * 考试管理中的选择试卷
     *
     * @param current
     * @param size
     * @param sjVO
     * @return
     */
    Page<SjVO> selectSjInfo(long current, long size, SjVO sjVO, SysUser sysUser);

    /**
     * 试卷审核列表查询
     *
     * @param current
     * @param size
     * @param sjVO
     * @return
     */
    Page<SjVO> ShPage(long current, long size, SjVO sjVO);

    /**
     * 审核试卷
     *
     * @param sjVO
     * @return
     */
    boolean shenghesj(SjVO sjVO);

    /**
     * 试卷操作记录
     *
     * @param sjId
     * @return
     */
    List<SjCzJlVO> querySjCzLs(String sjId);

    /**
     * 获取考评任务试卷列表
     *
     * @param kprwId 考评任务id
     * @param ksfs   考试方式 0 线下 1 线上
     * @return
     */
    List<KpRwSjGlVO> queryKprwSjList(String kprwId, String ksfs);

    /**
     * 查询试卷是否有试题信息
     *
     * @param sjId
     * @return
     */
    int queryStExist(String sjId);

    /**
     * 打印试卷答案
     *
     * @param sjId
     */
    List<SjUtilVO> querySjAnswer(String sjId);

    /**
     * 根据orgCode查询组织机构Id
     *
     * @param orgCode
     * @return
     */
    List<String> queryOrgIdCurrentOrgCode(String orgCode);

}
