package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.ksgl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysDic;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysOrg;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.ksgl.entity.KsRyGlVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.ksgl.entity.KsXxVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.ksgl.entity.SyKsInfoVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity.ZfRyXxVO;

import java.util.List;


/**
 * <p>
 * 考试信息 服务类
 * </p>
 *
 * @author pt
 * @since 2020-04-02
 */
public interface ZfksglJKsxxService {
    /**
     * 新增考试信息信息
     *
     * @param ksXxVO
     * @return
     */
    boolean insert(KsXxVO ksXxVO);

    /**
     * 修改考试信息信息
     *
     * @param ksXxVO
     * @return
     */
    boolean updateById(KsXxVO ksXxVO);

    /**
     * 根据ID删除考试信息信息
     *
     * @param id　考试信息ID
     * @return
     */
    boolean deleteById(String id);

    /**
     * 根据ID批量删除考试信息信息
     *
     * @param ksxxIds　考试信息ID
     * @return
     */
    boolean deleteByIds(String[] ksxxIds);

    /**
     * 根据ID删除参考机构信息
     *
     * @param ckjgId　考试信息ID
     * @return
     */
    boolean deleteckjgById(String ckjgId);

    /**
     * 根据ID批量删除参考机构信息
     *
     * @param ckjgIds　考试信息ID
     * @return
     */
    boolean deleteckjgByIds(String[] ckjgIds);





    /**
     * 根据ID获取考试信息信息
     *
     * @param id
     * @return
     */
    KsXxVO getById(String id);


    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @param ksXxVO
     * @return
     */
    Page<KsXxVO> page(long current, long size, KsXxVO ksXxVO, SysUser curUser);


    /**
     * 新增考试信息
     * @param ksXxVO
     * @return
     */
    boolean insertKsInfo(KsXxVO ksXxVO);

    /**
     * 查询参考机构
     * @param ksXxVO
     * @return
     */
    Page<SysOrg> queryOrgInfo(long current, long size, KsXxVO ksXxVO);

    /**
     * 随机抽取参考机构
     * @param ksXxVO
     * @return
     */
    List<SysOrg> querySjOrgInfo(KsXxVO ksXxVO);

    /**
     * 新增考试选择参考人员
     * @param current
     * @param size
     * @param zfRyXxVO
     * @return
     */
    Page<ZfRyXxVO> queryZfRyInfo(long current, long size, ZfRyXxVO zfRyXxVO);

    /**
     * 随机抽取参考人员
     * @param zfRyXxVO
     * @return
     */
    List<ZfRyXxVO> querySjCqRyInfo(ZfRyXxVO zfRyXxVO);

    /**
     * 更新考试信息
     * @param ksXxVO
     * @return
     */
    boolean updateKsInfo(KsXxVO ksXxVO);

    /**
     * 获取考试基本信息
     * @param ksxxId
     * @return
     */
    KsXxVO viewKsInfo(String ksxxId);

    /**
     * 参考机构列表数据获取
     * @param ksxxId
     * @return
     */
    KsXxVO viewCkJgInfo(String ksxxId);

    /**
     * 参考人员已选择的人员
     * @param ksXxVO
     * @return
     */
    List<KsXxVO> viewCkRyPageInfo(KsXxVO ksXxVO);

    /**
     * 查询与选择的参考机构详细信息
     * @param ksxxId
     * @return
     */
    KsXxVO viewAlreadyCkjgInfo(String ksxxId);

    /**
     * 证件年审查询 “评议考核”和“年度审验考试”
     * @param year
     * @param zfryxxId
     * @return
     */
    List<KsRyGlVO> ksqkByNd(String year, String zfryxxId);

    /**
     * 查询职务代码
     * @param zwdm
     * @param current
     * @param size
     * @return
     */
    Page<SysDic> queryZwDmList(String zwdm, long current, long size);

    /**
     * 更新线上考试未考的人员信息
     */
    void updateWkKsInfoTo();

    /**
     * 首页统计考试信息
     * @param cxfw
     * @param sj
     * @param type
     * @param curUser
     */
    SyKsInfoVO querySyKsInfo(String cxfw, String sj, String type, SysUser curUser);
}
