package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.ksgl.service;

/**
 * @Author peitao(181067)
 * @Version 1.0
 * @Date 2020/3/30
 * @Param
 * @Return
 **/

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.ksgl.entity.KsTkVO;

import java.util.Map;

/**
 * <p>
 * 考试题库 服务类
 * </p>
 *
 * @author pt
 * @since 2020-03-30
 */
public interface ZfksglJKstkService {

    /**
     * 新增考试题库信息
     *
     * @param ksTkVO
     * @return
     */
    boolean insert(KsTkVO ksTkVO);

    /**
     * 新增考试题库信息
     *
     * @param ksTkVO
     * @return
     */
    boolean insertkstk(KsTkVO ksTkVO);

    /**
     * 修改考试题库信息
     *
     * @param ksTkVO
     * @return
     */
    boolean updateById(KsTkVO ksTkVO);

    /**
     * 更新考试题库信息
     *
     * @param kstk
     * @return
     */
    boolean updateKsTkZt(KsTkVO kstk);

    /**
     * 根据ID批量删除考试题库信息
     *
     * @param kstk
     * @return
     */
    boolean deleteByIds(KsTkVO kstk);


    /**
     * 根据ID获取考试题库信息
     *
     * @param id
     * @return
     */
    KsTkVO getById(String id);


    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size    每页显示条数
     * @param ksTkVO
     * @return
     */
    Page<KsTkVO> page(long current, long size, KsTkVO ksTkVO);

    /**
     * 查询题库中是否存在试题
     *
     * @param kstkIds
     * @return
     */
    int queryTkExistSt(String[] kstkIds);

    /**
     * 查询市执法支队的orgCode
     * @param fjOrgCode
     * @return
     */
    String queryOrgCode(String fjOrgCode);

    /**
     * 批量启用题库
     *
     * @param kstkIds
     * @param curUser
     * @return
     */
    boolean updateStQyPl(String[] kstkIds, SysUser curUser);

    /**
     * 考试统计--题库图表数据
     *
     * @return
     */
    Map<String, Object> queryTkForCharts();

    /**
     * 考试统计--试题图表数据
     *
     * @return
     */
    Map<String, Object> queryStForCharts();

    /**
     * 考试统计--考试
     * @param orgId 组织机构
     * @param cxfw 查询范围
     * @param timeFlag 今年/本月
     * @param startTime 开始时间
     * @param endTime 结束时间
     * @return
     */
    Map<String,Object> queryKsForCharts(String orgId, String cxfw, String timeFlag, String startTime, String endTime);
}


