package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.ksgl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 试卷
 * </p>
 *
 * @author pt
 * @since 2020-04-01
 */
@Data
@TableName("ZFKSGL_J_SJ")
public class SjVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 试卷的唯一标识
     */
    @TableId
    private String sjId;


    /**
     * 组卷方式代码
     */
    private String zjfsdm;

    /**
     * 组织机构ID
     */
    private String zzjgid;

    /**
     * 试卷模板的唯一标识
     */
    private String sjmbId;

    /**
     * 版本号
     */
    private String bbh;

    /**
     * 名称
     */
    private String mc;

    /**
     * 总分
     */
    private String zf;

    /**
     * 时长，单位：分钟
     */
    private String sc;

    /**
     * 试卷状态：0 未报送 1 待审核 2 审核通过 3 已下发 9审核不通过
     */
    private String zt;

    /**
     * 简介
     */
    private String jj;

    /**
     * 执法门类代码，多个以逗号隔开
     */
    private String zfml;

    /**
     * 下发日期
     */
    private Date xfrq;

    /**
     * 审核意见
     */
    private String shyj;
    /**
     * 审核人ID
     */
    private String shrid;
    /**
     * 审核人
     */
    private String shrxm;
    /**
     * 使用用途：1 日常 2 评议考核
     */
    private String syyt;

    /****                       表外字段                                ******/

    /**
     * 试卷的唯一标识
     */
    @TableField(exist = false)
    private String[] sjIds;

    /**
     * 试卷状态：0 未报送 1 待审核 2 审核通过 3 已下发 9审核不通过
     */
    @TableField(exist = false)
    private String sjzt;

    /**
     * 执法门类代码数组
     */
    @TableField(exist = false)
    private String[] zfmldm;

    /**
     * 试题ID数组
     */
    @TableField(exist = false)
    private String[] stIds;
    /**
     * 模板节段ID数组
     */
    @TableField(exist = false)
    private String[] mbjdIdS;

    /**
     * 页面中组卷的数据格式
     * 前台传送的数据格式
     * {JdSt:[{"mbjdId":"01","stIds":["1","2"]},{"mbjdId":"02","stIds":["3","4 "]}]}
     */
    @TableField(exist = false)
    private String JdSt;
    /**
     * 标记
     */
    @TableField(exist = false)
    private Boolean flag;

    /**
     * 考试题库ID数组
     */
    @TableField(exist = false)
    private String[] kstkIdS;
    /**
     * 考试类型代码
     */
    @TableField(exist = false)
    private String kslxdm;
    /**
     * 考试方式
     */
    @TableField(exist = false)
    private String ksfs;
    /**
     * 下发日期字符串
     */
    @TableField(exist = false)
    private String xfrqStr;
    /**
     * 执法人员信息ID
     */
    @TableField(exist = false)
    private String zfryxxId;
    /**
     * 组织机构ID
     */
    @TableField(exist = false)
    private String orgId;
    /**
     * 执法人员姓名
     */
    @TableField(exist = false)
    private String xm;
    /**
     * 用户ID
     */
    @TableField(exist = false)
    private String userId;

    /**
     * 考评任务Id集合
     */
    @TableField(exist = false)
    private List<String> kprwIdList;

    /**
     * 考评任务ID
     */
    @TableField(exist = false)
    private String[] kprwIdS;
    /**
     * 创建时间字符串
     */
    @TableField(exist = false)
    private String createTimeStr;

    /**
     * 考试方式字典编码
     */
    @TableField(exist = false)
    private String ksfsCode;
    @Override
    public String getId() {
        return sjId;
    }

    @Override
    public void setId(String id) {
        this.sjId = id;
    }


}
