package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.ksgl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;


/**
 * <p>
 * 试卷包含的试题信息，冗余存储，因为试题可以随时修改
 * </p>
 *
 * @author 黄宇
 * @since 2020-04-22
 */
@Data
@TableName("ZFKSGL_J_SJ_ST_GL")
public class SjStGlVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 试卷的唯一标识
     */
    private String sjId;

    /**
     * 试题的唯一标识
     */
    private String stId;

    /**
     * 模板节段的唯一标识
     */
    private String mbjdId;

    /**
     * 试题难度代码
     */
    private String stnddm;

    /**
     * 执法人员执法门类的代码。
     */
    private String zfmldm;

    /**
     * 试题题型代码
     */
    private String sttxdm;

    /**
     * 编号
     */
    private String bh;

    /**
     * 内容
     */
    private String nr;

    /**
     * 答案
     */
    private String da;

    /**
     * 组卷次数
     */
    private String zjcs;
    /**
     * 排序
     */
    private String px;
    /**
     * 解析
     */
    private String jx;
    /**                                  表外字段                              **/

    @TableField(exist = false)
    private  String stAndXx;

    /**
     * 试题题型代码数组
     */
    @TableField(exist = false)
    private String[] sttxdmCode;


    /**
     * 序号
     */
    @TableField(exist = false)
    private String xh;

    /**
     * 节段标题
     */
    @TableField(exist = false)
    private String jdbt;

    /**
     * 试题数量
     */
    @TableField(exist = false)
    private Integer stsl;

    /**
     * 试题总分
     */
    @TableField(exist = false)
    private Integer stzf;

    @Override
    public String getId() {
        return sjId;
    }

    @Override
    public void setId(String id) {
        this.sjId = id;
    }


}
