package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.ksgl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.component.ComboboxVo;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 试卷模板
 * </p>
 *
 * @author pt
 * @since 2020-04-01
 */
@Data
@TableName("ZFKSGL_J_SJMB")
public class SjMbVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 试卷模板的唯一标识
     */
    @TableId
    private String sjmbId;


    /**
     * 版本号
     */
    private String bbh;

    /**
     * 组织机构ID
     */
    private String zzjgid;

    /**
     * 模板名称
     */
    private String mbmc;

    /**
     * 0 暂存 1 启用 9 禁用
     */
    private String zt;

    /**
     * 总分
     */
    private Integer zf;

    /**
     * 执法门类代码，多个以逗号隔开
     */
    private String zfml;

    /**
     * 启用日期
     */
    private Date qyrq;

    /**
     * 考试方式 0 线下 1 线上
     */
    private String ksfs;

    /****                         表外字段                                      ****/
    /**
     * 试卷模板的唯一标识数组
     */
    @TableField(exist = false)
    private String[] sjmbIds;

    /**
     * 0 暂存 1 启用 9 禁用
     */
    @TableField(exist = false)
    private String sjmbzt;
    /**
     * 试卷ID
     */
    @TableField(exist = false)
    private  String sjId;
    /**
     * 节段题型
     */
    @TableField(exist = false)
    private String jdtx;
    /**
     * 执法门类代码数组
     */
    @TableField(exist = false)
    private String[] zfmldm;

    /**
     * 提交的试卷模板信息
     * {"sjmbxx":[{"mbmc":"测试","bbh":"1.0","zf":"100","zfmldm":["02","12"]}],"jdxx":[{"jdtx ":"01","jdbt":"单选题","stsl":"30","stzf":"30"},{"jdtx ":"02","jdbt":"多选题","stsl":"30","stzf":"60"}]}
     */
    @TableField(exist = false)
    private String addSjMbInfo;


    /**
     * 需要删除的节段信息
     */
    @TableField(exist = false)
    private String[] deleteJdXxId;


    /**
     * 需要删除的试卷模板信息 用于删除试卷模板
     * {"mbxx":[{"sjmbId":"1","bbh":"1.0"}]}
     */
    @TableField(exist = false)
    private String deleteSjMbInfo;

    /**
     * 模板节段的集合
     */
    @TableField(exist = false)
    private List<MbJdVO> list;
    /**
     * 判断是启用和禁用的flag
     */
    @TableField(exist = false)
    private String flag;
    /**
     * 启用日期字符串
     */
    @TableField(exist = false)
    private String qyrqStr;

    /**
     *返回的字段题型下拉框字段
     */
    @TableField(exist = false)
    private List<ComboboxVo> comboboxVoList;
    /**
     * 前台控制的状态 模板的新版本
     */
    @TableField(exist = false)
    private  String status;
    /**
     * 题型数量
     */
    @TableField(exist = false)
    private  Integer stCount;
    /**
     *试题题型代码
     */
    @TableField(exist = false)
    private String sttxdm;

    @Override
    public String getId() {
        return sjmbId;
    }

    @Override
    public void setId(String id) {
        this.sjmbId = id;
    }


}
