package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.ksgl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysOrg;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 考试信息
 * </p>
 *
 * @author pt
 * @since 2020-04-02
 */
@Data
@TableName("ZFKSGL_J_KSXX")
public class KsXxVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 考试信息的唯一标识
     */
    @TableId
    private String ksxxId;

    /**
     * 试卷的唯一标识
     */
    private String sjId;

    /**
     * 组织机构ID
     */
    private String zzjgid;

    /**
     * 考试类型代码
     */
    private String kslxdm;

    /**
     * 考试科目代码
     */
    private String kskmdm;

    /**
     * 培训批次信息的唯一标识
     */
    private String pxpcxxId;

    /**
     * 考试名称
     */
    private String ksmc;

    /**
     * 简介
     */
    private String jj;

    /**
     * 考试开始时间
     */
    private Date kskssj;

    /**
     * 考试结束时间
     */
    private Date ksjssj;

    /**
     * 考试时长（单位：分钟）
     */
    private Integer kssc;

    /**
     * 合格分数
     */
    private Float hgfs;

    /**
     * 是否有培训
     */
    private String sfypx;

    /**
     * 0 暂存 1 提交
     */
    private String zt;

    /**
     * 考试方式 0 线下 1 线上
     */
    private String ksfs;
    /**
     * 人员添加方式
     */
    private String rytjfs;
    /**
     * 学分
     */
    private Float xf;
    /**
     * 加入代码
     */
    private String jrdm;
    /**
     * 平均分年龄范围
     */
    private String pjfnlfw;
    /**
     * 平均分
     */
    private Float pjf;
    /**
     * 打分状态 0 未打分 1 已打分
     */
    private String dfzt;

    /**
     * 是否通过，1是0否
     */
    @TableField(exist = false)
    private String sftg;

    /***                             表外字段                                           ***/

    /**
     * 是否通过，1是0否
     */
    @TableField(exist = false)
    private String sftgStr;
    /**
     * 0 暂存 1 提交
     */
    @TableField(exist = false)
    private String kszt;
    /**
     * 考试信息的唯一标识
     */
    @TableField(exist = false)
    private String[] ksxxIds;

    /**
     * 考试结束时间
     */
    @TableField(exist = false)
    private String ksjssjStart;
    @TableField(exist = false)
    private String ksjssjStr;
    @TableField(exist = false)
    private String ksjssjEnd;

    /**
     * 考试开始时间
     */
    @TableField(exist = false)
    private String kskssjStart;
    @TableField(exist = false)
    private String kskssjStr;
    @TableField(exist = false)
    private String kskssjEnd;

    /**
     * 合格分数字符串
     */
    @TableField(exist = false)
    private String hgfsStr;

    /**
     * 学分字符串
     */
    @TableField(exist = false)
    private String xfStr;
    /**
     * 参考机构数据 {"ckjg":[{"orgId":"111","ncqrs":"2","ycqrs":"2"}]}
     */
    @TableField(exist = false)
    private String jgInfo;
    /**
     * 参考机构数据 {"zfryxx":[{"orgId":"111","zfryxxId":["11","22"]}]}
     */
    @TableField(exist = false)
    private String zfryxx;
    /**
     * 考试时长字符串
     */
    @TableField(exist = false)
    private String ksscStr;

    /**
     * 参考人员信息ID
     */
    @TableField(exist = false)
    private String[] zfryxxIdS;

    /**
     * 考试类型字典值
     */
    @TableField(exist = false)
    private String kslxCode;
    /**
     * 组织机构ID
     */
    @TableField(exist = false)
    private String orgId;
    /**
     * 数量
     */
    @TableField(exist = false)
    private String num;
    /**
     * 参考机构信息
     */
    @TableField(exist = false)
    private List<KsJgGl> ksJgGlList;
    /**
     * 参考机构信息
     */
    @TableField(exist = false)
    private List<SysOrg> alreadyJgInfoList;
    /**
     * 参考机人员信息
     */
    @TableField(exist = false)
    private List<KsRyGlVO> ksRyGlVOList;
    /***
     * 删除的组织机构ID
     */
    @TableField(exist = false)
    private String[] deleteOrgId;
    /***
     * 删除的参考机构ID
     */
    @TableField(exist = false)
    private String[] deleteZfryxxIdS;


    /**
     * 执法人员基本信息的唯一标识。
     */
    @TableField(exist = false)
    private String zfryxxId;

    /**
     * 执法人员的姓名。
     */
    @TableField(exist = false)
    private String xm;

    /**
     * 执法人员执法门类的代码。
     */
    @TableField(exist = false)
    private String zfmldm;

    /**
     * 人员的性别代码。
     */
    @TableField(exist = false)
    private String xbdm;

    /**
     * 执法人员人员的身份证号码。
     */
    @TableField(exist = false)
    private String sfzjhm;

    /**
     * 执法证号
     */
    @TableField(exist = false)
    private String zfzh;

    /**
     * 执法机构名称
     */
    @TableField(exist = false)
    private String zfjgmc;
    /**
     *
     */
    @TableField(exist = false)
    private String orgName;

    /**
     * 试卷名称
     */
    @TableField(exist = false)
    private String mc;

    /**
     * 培训批次名称
     */
    @TableField(exist = false)
    private String pxpcmc;
    /**
     * 用户id
     */
    @TableField(exist = false)
    private String userId;

    /**
     * 考评任务中的考试信息ID集合
     */
    @TableField(exist = false)
    private List<String> ksxxIdList;

    /**
     * 标记
     */
    @TableField(exist = false)
    private boolean flag;
    /**
     * 考试开始时间的大小
     */
    @TableField(exist = false)
    private String daxiao;

    /**
     * 打分状态 0 未打分 1 已打分
     */
    @TableField(exist = false)
    private String dfztCode;
    /**
     * 考评任务ID
     */
    @TableField(exist = false)
    private String kprwId;
    /**
     * 试卷总分
     */
    @TableField(exist = false)
    private String zf;
    /**
     * 标记 用于前端进入考试 1 考试时间已结束 2 不在考试范围内  3 可以考试  4  资格考试(人员审批状态为培训通过、考试未通过、已发证的人员才能参加)
     */
    @TableField(exist = false)
    private String bj;
    /**
     * 已经参加过考试 1  0 未参加
     */
    @TableField(exist = false)
    private String alreadyKs;
    /**
     * 考试方式字典值
     */
    @TableField(exist = false)
    private String ksfsCode;
    /**
     * 试卷的考试方式
     */
    @TableField(exist = false)
    private String sjKsfs;
    /**
     * 考试成绩
     */
    @TableField(exist = false)
    private String kscj;
    /**
     * 参考人员的年龄
     */
    @TableField(exist = false)
    private String age;

    /**
     * 人员审批状态代码
     */
    @TableField(exist = false)
    private String ryspztdm;

    /**
     * 试卷时长
     */
    @TableField(exist = false)
    private String sjsj;

    @Override
    public String getId() {
        return ksxxId;
    }

    @Override
    public void setId(String id) {
        this.ksxxId = id;
    }

}
