package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.ksgl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 考试题库
 * </p>
 *
 * @author pt
 * @since 2020-03-30
 */
@Data
@TableName("ZFKSGL_J_KSTK")
public class KsTkVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 考试题库的唯一标识
     */
    @TableId
    private String kstkId;

    /**
     * 执法人员执法门类的代码。
     */
    private String zfmldm;

    /**
     * 排序
     */
    private String px;

    /**
     * 题库名称
     */
    private String tkmc;

    /**
     * 题库简介
     */
    private String tkjj;

    /**
     * 题库状态：0 已保存 1 启用 9 禁用
     */
    private String tkzt;

    /**
     * 启用日期
     */
    private Date qyrq;

    /**
     * 组织机构id
     */
    private String zzjgid;

    /**                       表外字段                         **/
    /**
     * 考试题库的唯一标识数组
     */
    @TableField(exist = false)
    private String[] kstkIds;

    /**
     * 题库状态：0 已保存 1 启用 9 禁用
     */
    @TableField(exist = false)
    private String zt;
    /**
     * 启用日期字符串
     */
    @TableField(exist = false)
    private String qyrqStr;
    /**
     * 题库中存在试题
     */
    @TableField(exist = false)
    private  int existSt;
    /**
     * 看到的范围 1 表示省执法局和市执法支队
     */
    @TableField(exist = false)
    private  String viewFw;
    /**
     * 机构编码
     */
    @TableField(exist = false)
    private List<String> orgCodeList;

    @Override
    public String getId() {
        return kstkId;
    }

    @Override
    public void setId(String id) {
        this.kstkId = id;
    }


}
