package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.ksgl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 考试里执法人员的考试情况
 * 增加字段：考生姓名，执法证号，身份证号，所属单位名称，考试成绩，考试结果，打分状态，试卷编号，试卷附件
 * </p>
 *
 * @author 黄宇
 * @since 2020-05-18
 */
@Data
@TableName("ZFKSGL_J_KS_RY_GL")
public class KsRyGlVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 考试信息的唯一标识
     */
    private String ksxxId;

    /**
     * 执法人员基本信息的唯一标识。
     */
    private String zfryxxId;

    /**
     * 组织机构ID
     */
    private String zzjgid;

    /**
     * 执法人员的姓名。
     */
    private String xm;

    /**
     * 执法人员执法门类的代码。
     */
    private String zfmldm;

    /**
     * 人员的性别代码。
     */
    private String xbdm;

    /**
     * 执法人员人员的身份证号码。
     */
    private String sfzjhm;

    /**
     * 执法证号
     */
    private String zfzh;

    /**
     * 执法机构名称
     */
    private String zfjgmc;

    /**
     * 打分状态 0 未打分 1 已打分
     */
    private String dfzt;

    /**
     * 考试成绩
     */
    private String kscj;

    /**
     * 是否通过，1是0否
     */
    private String sftg;

    /**
     * 日期+流水号组合为试卷编号
     */
    private String sjbh;

    /**
     * 试卷附件id
     */
    private String sjfjid;
    /**
     * 年龄
     */
    private String nl;
    /**
     * 出生日期
     */
    private Date csrq;
    /**
     * 交卷时间
     */
    private Date jjsj;
    /**
     * 所获学分
     */
    private Float shxf;

    /*****
     * 用户考试状态
     * 01-未参加考试
     * 02-已参加考试,未计算成绩
     * 03-已参加考试.且已计算成绩
     */
    private String yhkszt;

    /**                          表外字段                           **/

    /**
     * 考评任务ID
     */
    @TableField(exist = false)
    private String kprwId;
    /**
     * 考试类型代码
     */
    @TableField(exist = false)
    private String kslxdm;
    /**
     * 保存路径
     */
    @TableField(exist = false)
    private String bclj;
    /**
     * 附件ID
     */
    @TableField(exist = false)
    private String fjId;
    /**
     * 材料名称
     */
    @TableField(exist = false)
    private String clmc;
    /**
     * 上传的附件信息
     */
    @TableField(exist = false)
    private String fjInfo;
    /**
     * 考试名称
     */
    @TableField(exist = false)
    private String ksmc;
    /**
     * 考试开始时间
     */
    @TableField(exist = false)
    private Date kskssj;
    ;
    /**
     * 考试结束时间
     */
    @TableField(exist = false)
    private Date ksjssj;
    /**
     * 是否通过，1是0否
     */
    @TableField(exist = false)
    private String sftgStr;

    @Override
    public String getId() {
        return ksxxId;
    }

    @Override
    public void setId(String id) {
        this.ksxxId = id;
    }


}
